/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.math.BigInteger;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class UUIDUtil {
    public static String getUuid() {
        return UUID.randomUUID().toString();
    }

    public static String getUuid32() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static UUID fromString32(String uuid) {
        if (StringUtils.isEmpty((CharSequence)uuid)) {
            throw new NullPointerException("uuid can't be null");
        }
        if (uuid.length() == 36) {
            return UUID.fromString(uuid);
        }
        if (uuid.length() == 32) {
            StringBuilder uuidBuilder = new StringBuilder();
            uuidBuilder.append(uuid, 0, 8).append("-").append(uuid, 8, 12).append("-").append(uuid, 12, 16).append("-").append(uuid, 16, 24).append("-").append(uuid, 24, 32);
            return UUID.fromString(uuidBuilder.toString());
        }
        return null;
    }

    public static BigInteger uuidToBigInteger(UUID uuid) {
        BigInteger value2;
        BigInteger value1 = BigInteger.valueOf(uuid.getMostSignificantBits());
        if (value1.compareTo(value2 = BigInteger.valueOf(uuid.getLeastSignificantBits())) < 0) {
            return value2.multiply(value2).add(value1);
        }
        return value1.multiply(value1).add(value1).add(value2);
    }
}

