/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder.openapi;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiParam;
import com.power.doc.model.ApiReqParam;
import com.power.doc.model.openapi.OpenApiTag;
import com.power.doc.template.IDocBuildTemplate;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.OpenApiSchemaUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractOpenApiBuilder {
    protected static final Map<String, String> STRING_COMPONENT = new HashMap<String, String>();

    abstract void openApiCreate(ApiConfig var1, List<ApiDoc> var2);

    abstract Map<String, Object> buildPathUrlsRequest(ApiConfig var1, ApiMethodDoc var2, ApiDoc var3);

    abstract Map<String, Object> buildResponsesBody(ApiConfig var1, ApiMethodDoc var2);

    public Map<String, Object> buildPaths(ApiConfig apiConfig, List<ApiDoc> apiDocList, Set<OpenApiTag> tags) {
        HashMap<String, Object> pathMap = new HashMap<String, Object>(500);
        apiDocList.forEach(a -> {
            tags.add(OpenApiTag.of(a.getDesc(), a.getDesc()));
            List<ApiMethodDoc> apiMethodDocs = a.getList();
            apiMethodDocs.forEach(method -> {
                String url = method.getPath().replace("//", "/");
                Map<String, Object> request = this.buildPathUrls(apiConfig, (ApiMethodDoc)method, (ApiDoc)a);
                if (!pathMap.containsKey(url)) {
                    pathMap.put(url, request);
                } else {
                    Map oldRequest = (Map)pathMap.get(url);
                    oldRequest.putAll(request);
                }
            });
        });
        return pathMap;
    }

    public Map<String, Object> buildPathUrls(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, ApiDoc apiDoc) {
        HashMap<String, Object> request = new HashMap<String, Object>(4);
        request.put(apiMethodDoc.getType().toLowerCase(), this.buildPathUrlsRequest(apiConfig, apiMethodDoc, apiDoc));
        return request;
    }

    public static Map<String, Object> buildContent(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, boolean isRep, String componentKey) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        String contentType = apiMethodDoc.getContentType();
        if (isRep) {
            contentType = "*/*";
        }
        content.put(contentType, AbstractOpenApiBuilder.buildContentBody(apiConfig, apiMethodDoc, isRep, componentKey));
        return content;
    }

    public static Map<String, Object> buildContentBody(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc, boolean isRep, String componentKey) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        if ("#/definitions/".equals(componentKey) && !isRep) {
            content.put("name", apiMethodDoc.getName());
        }
        if (Objects.nonNull(apiMethodDoc.getReturnSchema()) && isRep) {
            content.put("schema", apiMethodDoc.getReturnSchema());
        } else if (!isRep && Objects.nonNull(apiMethodDoc.getRequestSchema())) {
            content.put("schema", apiMethodDoc.getRequestSchema());
        } else {
            content.put("schema", AbstractOpenApiBuilder.buildBodySchema(apiMethodDoc, isRep, componentKey));
        }
        if ("#/components/schemas/".equals(componentKey) && (!isRep && apiConfig.isRequestExample() || isRep && apiConfig.isResponseExample())) {
            content.put("examples", AbstractOpenApiBuilder.buildBodyExample(apiMethodDoc, isRep));
        }
        return content;
    }

    public static Map<String, Object> buildBodySchema(ApiMethodDoc apiMethodDoc, boolean isRep, String componentsKey) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        HashMap<String, String> innerScheme = new HashMap<String, String>(10);
        String requestRef = apiMethodDoc.getContentType().equals("application/x-www-form-urlencoded;charset=UTF-8") ? componentsKey + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getQueryParams()) : componentsKey + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getRequestParams());
        String responseRef = componentsKey + OpenApiSchemaUtil.getClassNameFromParams(apiMethodDoc.getResponseParams());
        if (apiMethodDoc.getIsRequestArray() == 1) {
            schema.put("type", "array");
            innerScheme.put("$ref", requestRef);
            schema.put("items", innerScheme);
        } else if (apiMethodDoc.getIsResponseArray() == 1) {
            schema.put("type", "array");
            innerScheme.put("$ref", responseRef);
            schema.put("items", innerScheme);
        } else if (isRep && CollectionUtil.isNotEmpty(apiMethodDoc.getResponseParams())) {
            schema.put("$ref", responseRef);
        } else if (!isRep && CollectionUtil.isNotEmpty(apiMethodDoc.getRequestParams())) {
            schema.put("$ref", requestRef);
        }
        return schema;
    }

    public static Map<String, Object> buildBodyExample(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("json", AbstractOpenApiBuilder.buildExampleData(apiMethodDoc, isRep));
        return content;
    }

    public static Map<String, Object> buildExampleData(ApiMethodDoc apiMethodDoc, boolean isRep) {
        HashMap<String, Object> content = new HashMap<String, Object>(8);
        content.put("summary", "test data");
        if (!isRep) {
            content.put("value", StringUtil.isEmpty((String)apiMethodDoc.getRequestExample().getJsonBody()) ? apiMethodDoc.getRequestExample().getExampleBody() : apiMethodDoc.getRequestExample().getJsonBody());
        } else {
            content.put("value", apiMethodDoc.getResponseUsage());
        }
        return content;
    }

    abstract List<Map<String, Object>> buildParameters(ApiMethodDoc var1);

    abstract Map<String, Object> getStringParams(ApiParam var1, boolean var2);

    public Map<String, Object> buildParametersSchema(ApiParam apiParam) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        schema.put("type", openApiType);
        if ("object".equals(openApiType) || "string".equals(openApiType)) {
            if ("file".equals(apiParam.getType())) {
                schema.put("format", "binary");
                schema.put("type", "string");
            } else if ("enum".equals(apiParam.getType())) {
                schema.put("enum", apiParam.getEnumValues());
            } else if ("array".equals(apiParam.getType())) {
                if (CollectionUtil.isNotEmpty(apiParam.getEnumValues())) {
                    schema.put("type", "string");
                    schema.put("items", apiParam.getEnumValues());
                } else {
                    schema.put("type", "array");
                    HashMap<String, String> map = new HashMap<String, String>(4);
                    map.put("type", "string");
                    map.put("format", "string");
                    schema.put("items", map);
                }
            }
        } else {
            schema.put("type", "integer");
            schema.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
        }
        return schema;
    }

    public static Map<String, Object> buildParametersSchema(ApiReqParam header) {
        HashMap<String, Object> schema = new HashMap<String, Object>(10);
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(header.getType());
        schema.put("type", openApiType);
        schema.put("format", "int16".equals(header.getType()) ? "int32" : header.getType());
        return schema;
    }

    public Map<String, Object> buildResponses(ApiConfig apiConfig, ApiMethodDoc apiMethodDoc) {
        HashMap<String, Object> response = new HashMap<String, Object>(10);
        response.put("200", this.buildResponsesBody(apiConfig, apiMethodDoc));
        return response;
    }

    public abstract Map<String, Object> buildComponentsSchema(List<ApiDoc> var1);

    public static Map<String, Object> buildProperties(List<ApiParam> apiParam, Map<String, Object> component, String commpentKey) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> propertiesData = new LinkedHashMap<String, Map<String, Object>>();
        ArrayList<String> requiredList = new ArrayList<String>();
        if (apiParam != null) {
            int paramsSize = apiParam.size();
            for (ApiParam param : apiParam) {
                if (param.isRequired()) {
                    requiredList.add(param.getField());
                }
                if (param.getType().equals("map") && paramsSize == 1 || param.isQueryParam() || param.isPathParam()) continue;
                String field = param.getField();
                propertiesData.put(field, AbstractOpenApiBuilder.buildPropertiesData(param, component, commpentKey));
            }
            if (!propertiesData.isEmpty()) {
                properties.put("properties", propertiesData);
            }
            if (!CollectionUtil.isEmpty(requiredList)) {
                properties.put("required", requiredList);
            }
            return properties;
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> buildPropertiesData(ApiParam apiParam, Map<String, Object> component, String componentKey) {
        HashMap<String, Object> propertiesData = new HashMap<String, Object>();
        String openApiType = DocUtil.javaTypeToOpenApiTypeConvert(apiParam.getType());
        propertiesData.put("description", apiParam.getDesc());
        propertiesData.put("example", StringUtil.removeDoubleQuotes((String)apiParam.getValue()));
        if (!"object".equals(openApiType)) {
            propertiesData.put("type", openApiType);
            propertiesData.put("format", "int16".equals(apiParam.getType()) ? "int32" : apiParam.getType());
        }
        if ("map".equals(apiParam.getType())) {
            propertiesData.put("type", "object");
            propertiesData.put("description", apiParam.getDesc() + "(map data)");
        }
        if ("array".equals(apiParam.getType())) {
            HashMap<String, String> arrayRef;
            propertiesData.put("type", "array");
            if (CollectionUtil.isNotEmpty(apiParam.getChildren())) {
                if (!apiParam.isSelfReferenceLoop()) {
                    arrayRef = new HashMap(4);
                    String childSchemaName = OpenApiSchemaUtil.getClassNameFromParams(apiParam.getChildren());
                    if (childSchemaName.contains("NO_BODY_PARAM")) {
                        propertiesData.put("type", "object");
                        propertiesData.put("description", apiParam.getDesc() + "(object)");
                    } else {
                        component.put(childSchemaName, AbstractOpenApiBuilder.buildProperties(apiParam.getChildren(), component, componentKey));
                        arrayRef.put("$ref", componentKey + childSchemaName);
                        propertiesData.put("items", arrayRef);
                    }
                }
            } else {
                arrayRef = new HashMap<String, String>(4);
                arrayRef.put("type", "string");
                propertiesData.put("items", arrayRef);
            }
        }
        if ("file".equals(apiParam.getType())) {
            propertiesData.put("type", "string");
            propertiesData.put("format", "binary");
        }
        if ("object".equals(apiParam.getType())) {
            if (CollectionUtil.isNotEmpty(apiParam.getChildren())) {
                propertiesData.put("type", "object");
                propertiesData.put("description", apiParam.getDesc() + "(object)");
                if (!apiParam.isSelfReferenceLoop()) {
                    String childSchemaName = OpenApiSchemaUtil.getClassNameFromParams(apiParam.getChildren());
                    if (childSchemaName.contains("NO_BODY_PARAM")) {
                        propertiesData.put("type", "object");
                        propertiesData.put("description", apiParam.getDesc() + "(object)");
                    } else {
                        component.put(childSchemaName, AbstractOpenApiBuilder.buildProperties(apiParam.getChildren(), component, componentKey));
                        propertiesData.put("$ref", componentKey + childSchemaName);
                    }
                }
            } else {
                propertiesData.put("type", "object");
                propertiesData.put("description", apiParam.getDesc() + "(object)");
            }
        }
        return propertiesData;
    }

    public List<ApiDoc> getOpenApiDocs(ApiConfig config, JavaProjectBuilder projectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, projectBuilder);
        config.setParamsDataToTree(true);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        return docBuildTemplate.getApiData(configBuilder);
    }

    static {
        STRING_COMPONENT.put("type", "string");
        STRING_COMPONENT.put("format", "string");
    }
}

