/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.common.util.StringUtil;
import com.power.common.util.UrlUtil;
import com.power.doc.utils.DocUtil;
import java.util.List;
import java.util.Optional;

public class DocUrlUtil {
    public static String getMvcUrls(String baseServer, String baseUrl, List<String> urls) {
        StringBuilder sb = new StringBuilder();
        List<String> baseUrls = DocUtil.split(baseUrl);
        int size = urls.size();
        int baseSize = baseUrls.size();
        for (int j = 0; j < baseSize; ++j) {
            String base = baseUrls.get(j);
            String trimBase = Optional.ofNullable(StringUtil.trimBlank((String)base)).orElse("");
            trimBase = trimBase.replace("[", "").replace("]", "");
            for (int i = 0; i < size; ++i) {
                String trimUrl = Optional.ofNullable(StringUtil.trimBlank((String)urls.get(i))).orElse("");
                String url = baseServer + "/" + trimBase + "/" + trimUrl;
                sb.append(UrlUtil.simplifyUrl((String)url));
                if (i >= size - 1) continue;
                sb.append(";\t");
            }
            if (j >= baseSize - 1) continue;
            sb.append(";\t");
        }
        return sb.toString();
    }

    public static String getMvcUrls(String baseServer, String baseUrl, String shortUrl) {
        List<String> urls = DocUtil.split(shortUrl);
        return DocUrlUtil.getMvcUrls(baseServer, baseUrl, urls);
    }
}

