/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractColorFunction;
import com.github.sommeri.less4j.core.compiler.expressions.ColorParameterUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

abstract class AbstractColorAmountFunction
extends AbstractColorFunction {
    private final ColorParameterUtils paramUtils = new ColorParameterUtils();
    private final boolean supportsRelativeOption;

    public AbstractColorAmountFunction(boolean supportsRelativeOption) {
        this.supportsRelativeOption = supportsRelativeOption;
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree token) {
        ColorExpression color = (ColorExpression)splitParameters.get(0);
        NumberExpression amount = splitParameters.size() > 1 ? (NumberExpression)splitParameters.get(1) : this.defaultAmount(color.getUnderlyingStructure());
        return this.evaluate(color, amount, this.paramUtils.isAbsolute(splitParameters, 2), token);
    }

    protected NumberExpression defaultAmount(HiddenTokenAwareTree underlying) {
        return new NumberExpression(underlying, 0.5, "", null, NumberExpression.Dimension.NUMBER);
    }

    protected abstract Expression evaluate(ColorExpression var1, NumberExpression var2, boolean var3, HiddenTokenAwareTree var4);

    @Override
    protected int getMinParameters() {
        return 2;
    }

    @Override
    protected int getMaxParameters() {
        return this.supportsRelativeOption ? 3 : 2;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        switch (position) {
            case 0: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.COLOR_EXPRESSION);
            }
            case 1: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
            }
            case 2: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, this.paramUtils.modeTypeAcceptableTypes());
            }
        }
        return false;
    }
}

