/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.expressions.GuardOnlyFunctions;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;

public class GuardsValidator {
    private final DefaultPoweredExpressionEvaluator ifDefaultExpressionEvaluator;
    private final DefaultPoweredExpressionEvaluator ifNotDefaultExpressionEvaluator;

    public GuardsValidator(IScope scope, ProblemsHandler problemsHandler) {
        this.ifDefaultExpressionEvaluator = new DefaultPoweredExpressionEvaluator(scope, problemsHandler, true);
        this.ifNotDefaultExpressionEvaluator = new DefaultPoweredExpressionEvaluator(scope, problemsHandler, false);
    }

    public boolean guardsSatisfied(ReusableStructure mixin, boolean assumeDefault) {
        if (assumeDefault) {
            return this.ifDefaultExpressionEvaluator.guardsSatisfied(mixin);
        }
        return this.ifNotDefaultExpressionEvaluator.guardsSatisfied(mixin);
    }

    private class DefaultPoweredExpressionEvaluator
    extends ExpressionEvaluator {
        public DefaultPoweredExpressionEvaluator(IScope scope, ProblemsHandler problemsHandler, boolean assumeDefault) {
            super(scope, problemsHandler);
            this.addFunctionsPack(new GuardOnlyFunctions(problemsHandler, assumeDefault));
        }

        public DefaultPoweredExpressionEvaluator(ProblemsHandler problemsHandler, boolean assumeDefault) {
            super(problemsHandler);
            this.addFunctionsPack(new GuardOnlyFunctions(problemsHandler, assumeDefault));
        }
    }
}

