/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractColorFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Mix
extends AbstractColorFunction {
    Mix() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree token) {
        NumberExpression weight;
        ColorExpression color1 = (ColorExpression)splitParameters.get(0);
        ColorExpression color2 = (ColorExpression)splitParameters.get(1);
        NumberExpression numberExpression = weight = splitParameters.size() > 2 ? (NumberExpression)splitParameters.get(2) : null;
        if (weight == null) {
            weight = new NumberExpression(token, 50.0, "%", null, NumberExpression.Dimension.PERCENTAGE);
        }
        return Mix.mix(color1, color2, weight, token);
    }

    @Override
    protected int getMinParameters() {
        return 2;
    }

    @Override
    protected int getMaxParameters() {
        return 3;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        switch (position) {
            case 0: 
            case 1: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.COLOR_EXPRESSION);
            }
            case 2: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
            }
        }
        return false;
    }

    @Override
    protected String getName() {
        return "mix";
    }
}

