/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.output;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.output.ExtendedStringBuilder;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.URIUtils;
import com.github.sommeri.sourcemap.FilePosition;
import com.github.sommeri.sourcemap.SourceMapFormat;
import com.github.sommeri.sourcemap.SourceMapGenerator;
import com.github.sommeri.sourcemap.SourceMapGeneratorFactory;
import java.io.IOException;

public class SourceMapBuilder {
    private final ExtendedStringBuilder cssBuilder;
    private final SourceMapGenerator generator;
    private LessSource cssDestination;

    public SourceMapBuilder(ExtendedStringBuilder cssBuilder, LessSource cssDestination) {
        this.cssBuilder = cssBuilder;
        this.cssDestination = cssDestination;
        this.generator = SourceMapGeneratorFactory.getInstance(SourceMapFormat.V3);
    }

    public void append(String str, HiddenTokenAwareTree sourceToken) {
        FilePosition outputStartPosition = this.beforeSymbolPosition();
        this.cssBuilder.append(str);
        FilePosition outputEndPosition = this.afterSymbolPosition();
        this.createMapping(str, sourceToken, outputStartPosition, outputEndPosition);
    }

    public void appendIgnoreNull(String str, HiddenTokenAwareTree sourceToken) {
        FilePosition outputStartPosition = this.beforeSymbolPosition();
        this.cssBuilder.append(str);
        FilePosition outputEndPosition = this.afterSymbolPosition();
        this.createMapping(str, sourceToken, outputStartPosition, outputEndPosition);
    }

    private void createMapping(String str, HiddenTokenAwareTree sourceToken, FilePosition outputStartPosition, FilePosition outputEndPosition) {
        FilePosition sourceStartPosition = this.toFilePosition(sourceToken);
        String sourceName = this.toSourceName(sourceToken);
        this.generator.addMapping(sourceName, str, sourceStartPosition, outputStartPosition, outputEndPosition);
    }

    private FilePosition beforeSymbolPosition() {
        this.cssBuilder.handleIndentation();
        FilePosition outputStartPosition = this.afterSymbolPosition();
        return outputStartPosition;
    }

    private FilePosition afterSymbolPosition() {
        return this.currentPosition();
    }

    private FilePosition currentPosition() {
        return new FilePosition(this.cssBuilder.getLine(), this.cssBuilder.getColumn());
    }

    public void append(SourceMapBuilder other) {
        FilePosition offset = this.afterSymbolPosition();
        this.cssBuilder.appendAsIs(other.cssBuilder.toString());
        SourceMapGenerator otherGenerator = other.generator;
        this.generator.offsetAndAppend(otherGenerator, offset);
    }

    private FilePosition toFilePosition(HiddenTokenAwareTree underlyingStructure) {
        FilePosition result = new FilePosition(underlyingStructure.getLine() - 1, underlyingStructure.getCharPositionInLine());
        return result;
    }

    private String toSourceName(HiddenTokenAwareTree underlyingStructure) {
        return URIUtils.relativizeSourceURIs(this.cssDestination, underlyingStructure.getSource());
    }

    public String toSourceMap() {
        String name = this.cssDestination.getName() == null ? "" : this.cssDestination.getName();
        try {
            StringBuilder sb = new StringBuilder();
            this.generator.appendTo(sb, name);
            return sb.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Impossible to happen exception.", e);
        }
    }

    protected ExtendedStringBuilder getCssBuilder() {
        return this.cssBuilder;
    }
}

