/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.java.lang.system;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.junit.rules.ExternalResource;

public class TextFromStandardInputStream
extends ExternalResource {
    private final SystemInMock systemInMock = new SystemInMock();
    private InputStream originalIn;

    public static TextFromStandardInputStream emptyStandardInputStream() {
        return new TextFromStandardInputStream("");
    }

    @Deprecated
    public TextFromStandardInputStream(String text) {
        this.provideText(text);
    }

    public void provideText(String text) {
        this.systemInMock.provideText(text);
    }

    protected void before() throws Throwable {
        this.originalIn = System.in;
        System.setIn(this.systemInMock);
    }

    protected void after() {
        System.setIn(this.originalIn);
    }

    private static class SystemInMock
    extends InputStream {
        private StringReader reader;

        private SystemInMock() {
        }

        public void provideText(String text) {
            this.reader = new StringReader(text);
        }

        public int read() throws IOException {
            return this.reader.read();
        }
    }
}

