/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.common.DateTimeOffset;
import com.github.tomakehurst.wiremock.common.DateTimeParser;
import com.github.tomakehurst.wiremock.common.DateTimeTruncation;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDateTimePattern
extends StringValuePattern {
    private final ZonedDateTime zonedDateTime;
    private final LocalDateTime localDateTime;
    private String actualDateTimeFormat;
    private DateTimeParser actualDateTimeParser;
    private DateTimeOffset expectedOffset;
    private DateTimeTruncation truncateExpected;
    private DateTimeTruncation truncateActual;

    protected AbstractDateTimePattern(String dateTimeSpec) {
        this(dateTimeSpec, null, (DateTimeTruncation)null, null, null, null);
    }

    protected AbstractDateTimePattern(DateTimeOffset offset, String actualDateTimeFormat, DateTimeTruncation truncateExpected, DateTimeTruncation truncateActual) {
        super(AbstractDateTimePattern.buildExpectedString(offset));
        this.expectedOffset = offset;
        this.localDateTime = null;
        this.zonedDateTime = null;
        this.actualDateTimeFormat = actualDateTimeFormat;
        this.actualDateTimeParser = actualDateTimeFormat != null ? DateTimeParser.forFormat(actualDateTimeFormat) : null;
        this.truncateExpected = truncateExpected;
        this.truncateActual = truncateActual;
    }

    protected AbstractDateTimePattern(String dateTimeSpec, String actualDateFormat, String truncateExpected, String truncateActual, Integer expectedOffsetAmount, DateTimeUnit expectedOffsetUnit) {
        this(dateTimeSpec, actualDateFormat, truncateExpected != null ? DateTimeTruncation.fromString(truncateExpected) : null, truncateActual != null ? DateTimeTruncation.fromString(truncateActual) : null, expectedOffsetAmount, expectedOffsetUnit);
    }

    protected AbstractDateTimePattern(String dateTimeSpec, String actualDateFormat, DateTimeTruncation truncateExpected, DateTimeTruncation truncateActual, Integer expectedOffsetAmount, DateTimeUnit expectedOffsetUnit) {
        super(dateTimeSpec);
        if (AbstractDateTimePattern.isNowOffsetExpression(dateTimeSpec)) {
            this.zonedDateTime = null;
            this.localDateTime = null;
            this.expectedOffset = expectedOffsetAmount != null && expectedOffsetUnit != null ? new DateTimeOffset(expectedOffsetAmount, expectedOffsetUnit) : DateTimeOffset.fromString(dateTimeSpec);
        } else {
            this.zonedDateTime = AbstractDateTimePattern.parseZonedOrNull(dateTimeSpec);
            this.localDateTime = AbstractDateTimePattern.parseLocalOrNull(dateTimeSpec);
            this.expectedOffset = null;
        }
        this.actualDateTimeFormat = actualDateFormat;
        this.actualDateTimeParser = this.actualDateTimeFormat != null ? DateTimeParser.forFormat(this.actualDateTimeFormat) : null;
        this.truncateExpected = truncateExpected;
        this.truncateActual = truncateActual;
    }

    public AbstractDateTimePattern(ZonedDateTime zonedDateTime) {
        this(zonedDateTime.toString(), zonedDateTime, null, null, null, null, null);
    }

    public AbstractDateTimePattern(LocalDateTime localDateTime) {
        this(localDateTime.toString(), null, localDateTime, null, null, null, null);
    }

    private AbstractDateTimePattern(String dateTimeSpec, ZonedDateTime zonedDateTime, LocalDateTime localDateTime, DateTimeOffset expectedOffset, String actualDatetimeFormat, DateTimeTruncation truncateExpected, DateTimeTruncation truncateActual) {
        super(dateTimeSpec);
        this.zonedDateTime = zonedDateTime;
        this.localDateTime = localDateTime;
        this.expectedOffset = expectedOffset;
        this.actualDateTimeFormat = actualDatetimeFormat;
        this.actualDateTimeParser = this.actualDateTimeFormat != null ? DateTimeParser.forFormat(this.actualDateTimeFormat) : null;
        this.truncateExpected = truncateExpected;
        this.truncateActual = truncateActual;
    }

    @Override
    public String getValue() {
        if (((String)this.expectedValue).equals("now") && this.expectedOffset != null) {
            return AbstractDateTimePattern.buildExpectedString(this.expectedOffset);
        }
        return (String)this.expectedValue;
    }

    private static String buildExpectedString(DateTimeOffset dateTimeOffset) {
        return dateTimeOffset.getAmount() >= 0 ? "now +" + dateTimeOffset : "now " + dateTimeOffset;
    }

    private static boolean isNowOffsetExpression(String dateTimeSpec) {
        return dateTimeSpec.equalsIgnoreCase("now") || dateTimeSpec.replaceAll("(?i)now ", "").matches("^[\\-+]?[0-9]+ [a-zA-Z]+$");
    }

    public <T extends AbstractDateTimePattern> T actualFormat(String format) {
        this.actualDateTimeFormat = format;
        this.actualDateTimeParser = DateTimeParser.forFormat(format);
        return (T)this;
    }

    public <T extends AbstractDateTimePattern> T expectedOffset(int amount, DateTimeUnit unit) {
        this.expectedOffset = new DateTimeOffset(amount, unit);
        return (T)this;
    }

    public <T extends AbstractDateTimePattern> T expectedOffset(DateTimeOffset offset) {
        this.expectedOffset = offset;
        return (T)this;
    }

    public <T extends AbstractDateTimePattern> T truncateExpected(DateTimeTruncation truncation) {
        this.truncateExpected = truncation;
        return (T)this;
    }

    public <T extends AbstractDateTimePattern> T truncateActual(DateTimeTruncation truncation) {
        this.truncateActual = truncation;
        return (T)this;
    }

    public String getActualFormat() {
        return this.actualDateTimeFormat;
    }

    public String getTruncateExpected() {
        return AbstractDateTimePattern.stringOrNull((Object)this.truncateExpected);
    }

    public String getTruncateActual() {
        return AbstractDateTimePattern.stringOrNull((Object)this.truncateActual);
    }

    private static String stringOrNull(Object obj) {
        return obj != null ? obj.toString() : null;
    }

    @Override
    public MatchResult match(String value) {
        ZonedDateTime zonedActual = this.truncateActual != null ? this.truncateActual.truncate(AbstractDateTimePattern.parseZonedOrNull(value, this.actualDateTimeParser)) : AbstractDateTimePattern.parseZonedOrNull(value, this.actualDateTimeParser);
        LocalDateTime localActual = AbstractDateTimePattern.parseLocalOrNull(value, this.actualDateTimeParser);
        ZonedDateTime zonedExpectedDateTime = this.isNowOffset() ? this.calculateExpectedFromNow() : this.zonedDateTime;
        return this.getMatchResult(zonedExpectedDateTime, this.localDateTime, zonedActual, localActual);
    }

    private ZonedDateTime calculateExpectedFromNow() {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime truncated = this.truncateExpected != null ? this.truncateExpected.truncate(now) : now;
        return this.expectedOffset.shift(truncated);
    }

    protected abstract MatchResult getMatchResult(ZonedDateTime var1, LocalDateTime var2, ZonedDateTime var3, LocalDateTime var4);

    private boolean isNowOffset() {
        return this.expectedOffset != null;
    }

    private static ZonedDateTime parseZonedOrNull(String dateTimeString) {
        return AbstractDateTimePattern.parseZonedOrNull(dateTimeString, (DateTimeParser)null);
    }

    private static ZonedDateTime parseZonedOrNull(String dateTimeString, DateTimeParser parser) {
        List<DateTimeParser> parsers = parser != null ? Collections.singletonList(parser) : DateTimeParser.ZONED_PARSERS;
        return AbstractDateTimePattern.parseZonedOrNull(dateTimeString, parsers);
    }

    private static ZonedDateTime parseZonedOrNull(String dateTimeString, List<DateTimeParser> parsers) {
        if (parsers.isEmpty()) {
            return null;
        }
        try {
            return parsers.get(0).parseZonedDateTime(dateTimeString);
        }
        catch (DateTimeParseException e) {
            return AbstractDateTimePattern.parseZonedOrNull(dateTimeString, parsers.subList(1, parsers.size()));
        }
    }

    private static LocalDateTime parseLocalOrNull(String dateTimeString) {
        return AbstractDateTimePattern.parseLocalOrNull(dateTimeString, null);
    }

    private static LocalDateTime parseLocalOrNull(String dateTimeString, DateTimeParser parser) {
        try {
            return parser != null ? parser.parseLocalDateTime(dateTimeString) : LocalDateTime.parse(dateTimeString);
        }
        catch (DateTimeParseException ignored) {
            try {
                return (parser != null ? parser.parseLocalDate(dateTimeString) : LocalDate.parse(dateTimeString)).atStartOfDay();
            }
            catch (DateTimeParseException ignored2) {
                return null;
            }
        }
    }
}

