/**
 * Copyright 2019 Anthony Trinh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.qos.logback.classic.db.names;

/**
 * Source of table and column names used in SQL queries generated by {@code ch.qos.logback.classic.db.DBAppender}
 *
 * Implement this interface to override default table and/or column names used by {@code ch.qos.logback.classic.db.DBAppender}.
 *
 * @author Tomasz Nurkiewicz
 * @author Ceki Gulcu
 * @since 0.9.19
 */
public interface DBNameResolver {

  <N extends Enum<?>> String getTableName(N tableName);

  <N extends Enum<?>> String getColumnName(N columnName);
}