/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.ThrowableProxyVO;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventVO
implements ILoggingEvent,
Serializable {
    private static final long serialVersionUID = 6553722650255690312L;
    private static final int NULL_ARGUMENT_ARRAY = -1;
    private static final String NULL_ARGUMENT_ARRAY_ELEMENT = "NULL_ARGUMENT_ARRAY_ELEMENT";
    private String threadName;
    private String loggerName;
    private LoggerContextVO loggerContextVO;
    private transient Level level;
    private String message;
    private transient String formattedMessage;
    private transient Object[] argumentArray;
    private ThrowableProxyVO throwableProxy;
    private StackTraceElement[] callerDataArray;
    private Marker marker;
    private Map<String, String> mdcPropertyMap;
    private long timeStamp;

    public static LoggingEventVO build(ILoggingEvent iLoggingEvent) {
        LoggingEventVO loggingEventVO = new LoggingEventVO();
        loggingEventVO.loggerName = iLoggingEvent.getLoggerName();
        loggingEventVO.loggerContextVO = iLoggingEvent.getLoggerContextVO();
        loggingEventVO.threadName = iLoggingEvent.getThreadName();
        loggingEventVO.level = iLoggingEvent.getLevel();
        loggingEventVO.message = iLoggingEvent.getMessage();
        loggingEventVO.argumentArray = iLoggingEvent.getArgumentArray();
        loggingEventVO.marker = iLoggingEvent.getMarker();
        loggingEventVO.mdcPropertyMap = iLoggingEvent.getMDCPropertyMap();
        loggingEventVO.timeStamp = iLoggingEvent.getTimeStamp();
        loggingEventVO.throwableProxy = ThrowableProxyVO.build(iLoggingEvent.getThrowableProxy());
        if (iLoggingEvent.hasCallerData()) {
            loggingEventVO.callerDataArray = iLoggingEvent.getCallerData();
        }
        return loggingEventVO;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public LoggerContextVO getLoggerContextVO() {
        return this.loggerContextVO;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }

    @Override
    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    @Override
    public IThrowableProxy getThrowableProxy() {
        return this.throwableProxy;
    }

    @Override
    public StackTraceElement[] getCallerData() {
        return this.callerDataArray;
    }

    @Override
    public boolean hasCallerData() {
        return this.callerDataArray != null;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getContextBirthTime() {
        return this.loggerContextVO.getBirthTime();
    }

    public LoggerContextVO getContextLoggerRemoteView() {
        return this.loggerContextVO;
    }

    @Override
    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    @Override
    public Map<String, String> getMdc() {
        return this.mdcPropertyMap;
    }

    @Override
    public void prepareForDeferredProcessing() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.level.levelInt);
        if (this.argumentArray != null) {
            int n = this.argumentArray.length;
            objectOutputStream.writeInt(n);
            for (int i = 0; i < this.argumentArray.length; ++i) {
                if (this.argumentArray[i] != null) {
                    objectOutputStream.writeObject(this.argumentArray[i].toString());
                    continue;
                }
                objectOutputStream.writeObject(NULL_ARGUMENT_ARRAY_ELEMENT);
            }
        } else {
            objectOutputStream.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.level = Level.toLevel(n);
        int n2 = objectInputStream.readInt();
        if (n2 != -1) {
            this.argumentArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                Object object = objectInputStream.readObject();
                if (NULL_ARGUMENT_ARRAY_ELEMENT.equals(object)) continue;
                this.argumentArray[i] = object;
            }
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.message == null ? 0 : this.message.hashCode());
        n = 31 * n + (this.threadName == null ? 0 : this.threadName.hashCode());
        n = 31 * n + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LoggingEventVO loggingEventVO = (LoggingEventVO)object;
        if (this.message == null ? loggingEventVO.message != null : !this.message.equals(loggingEventVO.message)) {
            return false;
        }
        if (this.loggerName == null ? loggingEventVO.loggerName != null : !this.loggerName.equals(loggingEventVO.loggerName)) {
            return false;
        }
        if (this.threadName == null ? loggingEventVO.threadName != null : !this.threadName.equals(loggingEventVO.threadName)) {
            return false;
        }
        if (this.timeStamp != loggingEventVO.timeStamp) {
            return false;
        }
        if (this.marker == null ? loggingEventVO.marker != null : !this.marker.equals((Object)loggingEventVO.marker)) {
            return false;
        }
        return !(this.mdcPropertyMap == null ? loggingEventVO.mdcPropertyMap != null : !this.mdcPropertyMap.equals(loggingEventVO.mdcPropertyMap));
    }
}

