/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowableToStringArray {
    public static String[] convert(Throwable throwable) {
        LinkedList<String> linkedList = new LinkedList<String>();
        ThrowableToStringArray.extract(linkedList, throwable, null);
        return linkedList.toArray(new String[0]);
    }

    private static void extract(List<String> list, Throwable throwable, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable2;
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = ThrowableToStringArray.findNumberOfCommonFrames(stackTraceElementArray2, stackTraceElementArray);
        list.add(ThrowableToStringArray.formatFirstLine(throwable, stackTraceElementArray));
        for (int i = 0; i < stackTraceElementArray2.length - n; ++i) {
            list.add("\tat " + stackTraceElementArray2[i].toString());
        }
        if (n != 0) {
            list.add("\t... " + n + " common frames omitted");
        }
        if ((throwable2 = throwable.getCause()) != null) {
            ThrowableToStringArray.extract(list, throwable2, stackTraceElementArray2);
        }
    }

    private static String formatFirstLine(Throwable throwable, StackTraceElement[] stackTraceElementArray) {
        String string = "";
        if (stackTraceElementArray != null) {
            string = "Caused by: ";
        }
        String string2 = string + throwable.getClass().getName();
        if (throwable.getMessage() != null) {
            string2 = string2 + ": " + throwable.getMessage();
        }
        return string2;
    }

    private static int findNumberOfCommonFrames(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        if (stackTraceElementArray2 == null) {
            return 0;
        }
        int n = stackTraceElementArray.length - 1;
        int n2 = 0;
        for (int i = stackTraceElementArray2.length - 1; n >= 0 && i >= 0 && stackTraceElementArray[n].equals(stackTraceElementArray2[i]); --n, --i) {
            ++n2;
        }
        return n2;
    }
}

