/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.util.CloseUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerSocketListener<T extends Client>
implements ServerListener<T> {
    private final ServerSocket serverSocket;

    public ServerSocketListener(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    @Override
    public T acceptClient() throws IOException {
        Socket socket = this.serverSocket.accept();
        return this.createClient(this.socketAddressToString(socket.getRemoteSocketAddress()), socket);
    }

    protected abstract T createClient(String var1, Socket var2) throws IOException;

    @Override
    public void close() {
        CloseUtil.closeQuietly(this.serverSocket);
    }

    public String toString() {
        return this.socketAddressToString(this.serverSocket.getLocalSocketAddress());
    }

    private String socketAddressToString(SocketAddress socketAddress) {
        String string = socketAddress.toString();
        int n = string.indexOf("/");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }
}

