/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import android.text.TextUtils;
import ch.qos.logback.core.rolling.helper.FileProvider;
import ch.qos.logback.core.rolling.helper.LiteralPathPart;
import ch.qos.logback.core.rolling.helper.PathPart;
import ch.qos.logback.core.rolling.helper.RegexPathPart;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileFinder {
    private static final String REGEX_MARKER_START = "(?:\ufffe)?";
    private static final String REGEX_MARKER_END = "(?:\uffff)?";
    private FileProvider fileProvider;

    FileFinder(FileProvider fileProvider) {
        this.fileProvider = fileProvider;
    }

    List<String> findFiles(String string) {
        List<PathPart> list = this.splitPath(string);
        PathPart pathPart = list.get(0);
        List<File> list2 = this.findFiles(pathPart.listFiles(this.fileProvider), list, 1);
        return this.toAbsolutePaths(list2);
    }

    List<String> findDirs(String string) {
        List<PathPart> list = this.splitPath(string);
        PathPart pathPart = list.get(0);
        ArrayList<File> arrayList = new ArrayList<File>();
        this.findDirs(pathPart.listFiles(this.fileProvider), list, 1, arrayList);
        return this.toAbsolutePaths(arrayList);
    }

    private List<String> toAbsolutePaths(List<File> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file : list) {
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    private List<File> findFiles(List<File> list, List<PathPart> list2, int n) {
        ArrayList<File> arrayList = new ArrayList<File>();
        PathPart pathPart = list2.get(n);
        if (n >= list2.size() - 1) {
            for (File file : list) {
                if (!pathPart.matches(file)) continue;
                arrayList.add(file);
            }
            return arrayList;
        }
        for (File file : list) {
            if (!this.fileProvider.isDirectory(file) || !pathPart.matches(file)) continue;
            List<File> list3 = this.findFiles(Arrays.asList(this.fileProvider.listFiles(file, null)), list2, n + 1);
            arrayList.addAll(list3);
        }
        return arrayList;
    }

    private void findDirs(List<File> list, List<PathPart> list2, int n, List<File> list3) {
        if (n >= list2.size() - 1) {
            return;
        }
        PathPart pathPart = list2.get(n);
        for (File file : list) {
            if (!this.fileProvider.isDirectory(file) || !pathPart.matches(file)) continue;
            list3.add(file);
            this.findDirs(Arrays.asList(this.fileProvider.listFiles(file, null)), list2, n + 1, list3);
        }
    }

    List<PathPart> splitPath(String string) {
        ArrayList<PathPart> arrayList = new ArrayList<PathPart>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : string.split(File.separator)) {
            boolean bl = string2.contains(REGEX_MARKER_START) && string2.contains(REGEX_MARKER_END);
            string2 = string2.replace(REGEX_MARKER_START, "").replace(REGEX_MARKER_END, "");
            if (bl) {
                if (!arrayList2.isEmpty()) {
                    arrayList.add(new LiteralPathPart(TextUtils.join((CharSequence)File.separator, arrayList2)));
                    arrayList2.clear();
                }
                arrayList.add(new RegexPathPart(string2));
                continue;
            }
            arrayList2.add(string2);
        }
        if (!arrayList2.isEmpty()) {
            arrayList.add(new LiteralPathPart(TextUtils.join((CharSequence)File.separator, arrayList2)));
        }
        return arrayList;
    }

    static String regexEscapePath(String string) {
        if (string.contains(File.separator)) {
            Object[] objectArray = string.split(File.separator);
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].length() <= 0) continue;
                objectArray[i] = REGEX_MARKER_START + (String)objectArray[i] + REGEX_MARKER_END;
            }
            return TextUtils.join((CharSequence)File.separator, (Object[])objectArray);
        }
        return REGEX_MARKER_START + string + REGEX_MARKER_END;
    }

    static String unescapePath(String string) {
        return string.replace(REGEX_MARKER_START, "").replace(REGEX_MARKER_END, "");
    }
}

