/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.OptionHelper;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";
    private static boolean ignoreTCL = false;
    public static final String IGNORE_TCL_PROPERTY_NAME = "logback.ignoreTCL";
    private static boolean HAS_GET_CLASS_LOADER_PERMISSION = false;

    public static Set<URL> getResourceOccurrenceCount(String string, ClassLoader classLoader) throws IOException {
        HashSet<URL> hashSet = new HashSet<URL>();
        Enumeration<URL> enumeration = classLoader.getResources(string);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            hashSet.add(uRL);
        }
        return hashSet;
    }

    public static URL getResource(String string, ClassLoader classLoader) {
        try {
            return classLoader.getResource(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static URL getResourceBySelfClassLoader(String string) {
        return Loader.getResource(string, Loader.getClassLoaderOfClass(Loader.class));
    }

    public static ClassLoader getTCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String string, Context context) throws ClassNotFoundException {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(context);
        return classLoader.loadClass(string);
    }

    public static ClassLoader getClassLoaderOfObject(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument cannot be null");
        }
        return Loader.getClassLoaderOfClass(object.getClass());
    }

    public static ClassLoader getClassLoaderAsPrivileged(final Class<?> clazz) {
        if (!HAS_GET_CLASS_LOADER_PERMISSION) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz.getClassLoader();
            }
        });
    }

    public static ClassLoader getClassLoaderOfClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Class<?> loadClass(String string) throws ClassNotFoundException {
        if (ignoreTCL) {
            return Class.forName(string);
        }
        try {
            return Loader.getTCL().loadClass(string);
        }
        catch (Throwable throwable) {
            return Class.forName(string);
        }
    }

    static {
        String string = OptionHelper.getSystemProperty(IGNORE_TCL_PROPERTY_NAME, null);
        if (string != null) {
            ignoreTCL = Boolean.valueOf(string);
        }
        HAS_GET_CLASS_LOADER_PERMISSION = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    AccessController.checkPermission(new RuntimePermission("getClassLoader"));
                    return true;
                }
                catch (SecurityException securityException) {
                    return false;
                }
            }
        });
    }
}

