/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.assertion.field.header;

import com.browserup.bup.assertion.field.HarEntryPredicate;
import com.browserup.bup.assertion.field.header.HeadersPassPredicateAssertion;
import de.sstoehr.harreader.model.HarHeader;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class HeadersContainStringAssertion
extends HeadersPassPredicateAssertion {
    private final String value;

    public HeadersContainStringAssertion(String value) {
        this.value = value;
    }

    @Override
    public HarEntryPredicate<List<com.browserup.harreader.model.HarHeader>> getHarEntryPredicate() {
        return harHeaders -> {
            Optional<Object> result = Optional.empty();
            boolean contains = harHeaders.stream().filter(NONEMPTY_HEADER_FILTER).map(HarHeader::getValue).anyMatch(hv -> StringUtils.contains((CharSequence)hv, (CharSequence)this.value));
            if (!contains) {
                result = Optional.of(String.format("Expected to find one or more headers containing string: '%s'", this.value));
            }
            return result;
        };
    }
}

