/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.filters.HttpsAwareFiltersAdapter;
import com.browserup.bup.proxy.BlocklistEntry;
import com.browserup.bup.util.HttpStatusClass;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.util.Collection;
import java.util.Collections;

public class BlocklistFilter
extends HttpsAwareFiltersAdapter {
    public static final String BLOCKED_PHRASE = "Request blocked";
    private final Collection<BlocklistEntry> blocklistedUrls;

    public BlocklistFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, Collection<BlocklistEntry> blocklistedUrls) {
        super(originalRequest, ctx);
        this.blocklistedUrls = blocklistedUrls != null ? blocklistedUrls : Collections.emptyList();
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            String url = this.getOriginalUrl();
            for (BlocklistEntry entry : this.blocklistedUrls) {
                if (HttpMethod.CONNECT.equals((Object)httpRequest.method()) && entry.getHttpMethodPattern() == null || !entry.matches(url, httpRequest.method().name())) continue;
                HttpResponseStatus status = HttpStatusClass.UNKNOWN.equals((Object)HttpStatusClass.valueOf(entry.getStatusCode())) ? new HttpResponseStatus(entry.getStatusCode(), BLOCKED_PHRASE) : HttpResponseStatus.valueOf((int)entry.getStatusCode());
                DefaultFullHttpResponse resp = new DefaultFullHttpResponse(httpRequest.protocolVersion(), status);
                HttpUtil.setContentLength((HttpMessage)resp, (long)0L);
                return resp;
            }
        }
        return null;
    }
}

