/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy.addons;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAddon {
    private static final String BROWSERUP_PROXY_ADDONS_PATH_ENV = "BROWSERUP_PROXY_ADDONS_PATH";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAddon.class);
    private static final Map<String, String> ADDONS_CACHE = new HashMap<String, String>();

    public abstract String[] getCommandParams();

    public abstract String getAddOnFileName();

    public String getAddOnFilePath() {
        return ADDONS_CACHE.computeIfAbsent(this.getAddOnFileName(), fn -> {
            try {
                return this.loadHarDumpAddOn();
            }
            catch (Exception e) {
                LOGGER.error("Couldn't load add on by file name", (Throwable)e);
                throw new RuntimeException("Couldn't load add on by file name", e);
            }
        });
    }

    private Optional<String> getRootDirectoryEnv() {
        return Optional.ofNullable(System.getenv(BROWSERUP_PROXY_ADDONS_PATH_ENV));
    }

    private String loadHarDumpAddOn() throws Exception {
        String addOnFileName = this.getAddOnFileName();
        URL defaultUrl = AbstractAddon.class.getResource("/mitmproxy/" + addOnFileName);
        URL resource = this.getRootDirectoryEnv().map(rootDir -> {
            try {
                return new File(rootDir + addOnFileName).toURI().toURL();
            }
            catch (MalformedURLException e) {
                return defaultUrl;
            }
        }).orElse(defaultUrl);
        String addOnString = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        File addOnFile = File.createTempFile(addOnFileName, ".py");
        Files.write(addOnFile.toPath(), addOnString.getBytes(), new OpenOption[0]);
        return addOnFile.getAbsolutePath();
    }
}

