/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy.management;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.tuple.Pair;

public class AddonsManagerClient {
    private final int port;
    private final String host = "localhost";

    public AddonsManagerClient(int port) {
        this.port = port;
    }

    public <T> T putRequestToAddonsManager(String addOnPath, String operation, List<Pair<String, String>> queryParams, RequestBody requestBody, Class<T> responseClass) {
        return this.requestToAddonsManager(addOnPath, operation, queryParams, "PUT", requestBody, responseClass);
    }

    public <T> T getRequestToAddonsManager(String addOnPath, String operation, List<Pair<String, String>> queryParams, Class<T> responseClass) {
        return this.requestToAddonsManager(addOnPath, operation, queryParams, "GET", null, responseClass);
    }

    public <T> T requestToAddonsManager(String addOnPath, String operation, List<Pair<String, String>> queryParams, String method, RequestBody requestBody, Class<T> responseClass) {
        Response response;
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(this.buildRequestUrl(addOnPath, operation, queryParams)).method(method, requestBody).build();
        try {
            response = client.newCall(request).execute();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to request manager API", ex);
        }
        try {
            if (responseClass.equals(Void.class)) {
                T ex = null;
                return ex;
            }
            if (responseClass.equals(String.class)) {
                String ex = response.body().string();
                return (T)ex;
            }
            Object ex = new ObjectMapper().readerFor(responseClass).readValue(Objects.requireNonNull(response.body()).byteStream());
            return (T)ex;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse response from manager API", e);
        }
        finally {
            ResponseBody body = response.body();
            if (body != null) {
                body.close();
            }
        }
    }

    private HttpUrl buildRequestUrl(String addOnPath, String operation, List<Pair<String, String>> queryParams) {
        HttpUrl.Builder builder = new HttpUrl.Builder().host("localhost").port(this.port).scheme("http").addPathSegment(addOnPath).addPathSegment(operation);
        queryParams.forEach(p -> builder.addQueryParameter((String)p.getKey(), (String)p.getValue()));
        return builder.build();
    }
}

