/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy.management;

import com.browserup.bup.mitmproxy.MitmProxyProcessManager;
import com.browserup.bup.mitmproxy.management.AddonsManagerClient;
import com.browserup.bup.proxy.Allowlist;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class AllowListManager {
    private final AddonsManagerClient addonsManagerClient;
    private final MitmProxyProcessManager mitmProxyManager;
    private final AtomicReference<Allowlist> allowlist = new AtomicReference<Allowlist>(Allowlist.ALLOWLIST_DISABLED);

    public AllowListManager(AddonsManagerClient addonsManagerClient, MitmProxyProcessManager mitmProxyManager) {
        this.addonsManagerClient = addonsManagerClient;
        this.mitmProxyManager = mitmProxyManager;
    }

    public void allowlistRequests(final Collection<String> urlPatterns, final int statusCode) {
        this.allowlist.set(new Allowlist(urlPatterns, statusCode));
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("allowlist", "allowlist_requests", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"urlPatterns", (Object)String.valueOf(urlPatterns)));
                this.add(Pair.of((Object)"statusCode", (Object)String.valueOf(statusCode)));
            }
        }, Void.class);
    }

    public void addAllowlistPattern(final String urlPattern) {
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        boolean allowlistUpdated = false;
        while (!allowlistUpdated) {
            Allowlist currentAllowlist = this.allowlist.get();
            if (!currentAllowlist.isEnabled()) {
                throw new IllegalStateException("Allowlist is disabled. Cannot add patterns to a disabled allowlist.");
            }
            int statusCode = currentAllowlist.getStatusCode();
            List newPatterns = currentAllowlist.getPatterns().stream().map(Pattern::pattern).collect(Collectors.toCollection(() -> new ArrayList(currentAllowlist.getPatterns().size() + 1)));
            newPatterns.add(urlPattern);
            Allowlist newAllowlist = new Allowlist(newPatterns, statusCode);
            allowlistUpdated = this.allowlist.compareAndSet(currentAllowlist, newAllowlist);
            this.addonsManagerClient.getRequestToAddonsManager("allowlist", "add_allowlist_pattern", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
                {
                    this.add(Pair.of((Object)"urlPattern", (Object)String.valueOf(urlPattern)));
                }
            }, Void.class);
        }
    }

    public void enableEmptyAllowlist(final int statusCode) {
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.allowlist.set(new Allowlist(statusCode));
        this.addonsManagerClient.getRequestToAddonsManager("allowlist", "enable_empty_allowlist", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"statusCode", (Object)String.valueOf(statusCode)));
            }
        }, Void.class);
    }

    public void disableAllowlist() {
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.allowlist.set(Allowlist.ALLOWLIST_DISABLED);
        this.addonsManagerClient.getRequestToAddonsManager("allowlist", "disable_allowlist", new ArrayList<Pair<String, String>>(), Void.class);
    }

    public int getAllowlistStatusCode() {
        return this.allowlist.get().getStatusCode();
    }

    public boolean isAllowlistEnabled() {
        return this.allowlist.get().isEnabled();
    }

    public Collection<String> getAllowlistUrls() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.allowlist.get().getPatterns().stream().map(Pattern::pattern).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }
}

