/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy.management;

import com.browserup.bup.mitmproxy.MitmProxyProcessManager;
import com.browserup.bup.mitmproxy.management.AddonsManagerClient;
import com.browserup.bup.proxy.BlocklistEntry;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.tuple.Pair;

public class BlockListManager {
    private final AddonsManagerClient addonsManagerClient;
    private final MitmProxyProcessManager mitmProxyManager;
    private volatile Collection<BlocklistEntry> blocklistEntries = new CopyOnWriteArrayList<BlocklistEntry>();

    public BlockListManager(AddonsManagerClient addonsManagerClient, MitmProxyProcessManager mitmProxyManager) {
        this.addonsManagerClient = addonsManagerClient;
        this.mitmProxyManager = mitmProxyManager;
    }

    public void blocklistRequests(final String urlPattern, final int statusCode) {
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.blocklistEntries.add(new BlocklistEntry(urlPattern, statusCode));
        this.addonsManagerClient.getRequestToAddonsManager("blocklist", "blocklist_requests", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"urlPattern", (Object)String.valueOf(urlPattern)));
                this.add(Pair.of((Object)"statusCode", (Object)String.valueOf(statusCode)));
            }
        }, Void.class);
    }

    public void blocklistRequests(final String urlPattern, final int statusCode, final String httpMethodPattern) {
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.blocklistEntries.add(new BlocklistEntry(urlPattern, statusCode, httpMethodPattern));
        this.addonsManagerClient.getRequestToAddonsManager("blocklist", "blocklist_requests", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"urlPattern", (Object)String.valueOf(urlPattern)));
                this.add(Pair.of((Object)"statusCode", (Object)String.valueOf(statusCode)));
                this.add(Pair.of((Object)"httpMethodPattern", (Object)String.valueOf(httpMethodPattern)));
            }
        }, Void.class);
    }

    public void setBlocklist(Collection<BlocklistEntry> blocklist) {
        String serializedBlockList;
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.blocklistEntries = new CopyOnWriteArrayList<BlocklistEntry>(blocklist);
        try {
            serializedBlockList = new ObjectMapper().writeValueAsString(blocklist);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Couldn't serialize block list", e);
        }
        this.addonsManagerClient.putRequestToAddonsManager("blocklist", "set_block_list", Collections.emptyList(), RequestBody.create((String)serializedBlockList, (MediaType)MediaType.parse((String)"application/json; charset=utf-8")), Void.class);
    }

    public Collection<BlocklistEntry> getBlocklist() {
        return Collections.unmodifiableCollection(this.blocklistEntries);
    }

    public void clearBlockList() {
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.blocklistEntries.clear();
        this.setBlocklist(Collections.emptyList());
    }
}

