/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy.management;

import com.browserup.bup.mitmproxy.MitmProxyProcessManager;
import com.browserup.bup.mitmproxy.management.AddonsManagerClient;
import com.browserup.bup.proxy.CaptureType;
import com.browserup.harreader.model.Har;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarCaptureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HarCaptureManager.class);
    private final AddonsManagerClient addonsManagerClient;
    private final MitmProxyProcessManager mitmProxyManager;
    private EnumSet<CaptureType> lastCaptureTypes = EnumSet.noneOf(CaptureType.class);

    public HarCaptureManager(AddonsManagerClient addonsManagerClient, MitmProxyProcessManager mitmProxyManager) {
        this.addonsManagerClient = addonsManagerClient;
        this.mitmProxyManager = mitmProxyManager;
    }

    public Har getHar() {
        return this.getHar(false);
    }

    public Har getHar(final Boolean cleanHar) {
        if (!this.mitmProxyManager.isRunning()) {
            return null;
        }
        HarResponse response = this.addonsManagerClient.getRequestToAddonsManager("har", "get_har", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"cleanHar", (Object)String.valueOf(cleanHar)));
            }
        }, HarResponse.class);
        LOGGER.info("Parsing HAR from file: {}", (Object)response.path);
        return this.parseHar(response.path);
    }

    public Har newHar() {
        return this.newHar(null, null);
    }

    public Har newHar(String pageRef) {
        return this.newHar(pageRef, null);
    }

    public Har newHar(final String pageRef, final String pageTitle) {
        if (!this.mitmProxyManager.isRunning()) {
            return null;
        }
        HarResponse response = this.addonsManagerClient.getRequestToAddonsManager("har", "new_har", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"pageRef", (Object)pageRef));
                this.add(Pair.of((Object)"pageTitle", (Object)pageTitle));
            }
        }, HarResponse.class);
        return this.parseHar(response.path);
    }

    public Har endHar() {
        if (!this.mitmProxyManager.isRunning()) {
            return null;
        }
        HarResponse response = this.addonsManagerClient.getRequestToAddonsManager("har", "end_har", Collections.emptyList(), HarResponse.class);
        return this.parseHar(response.path);
    }

    public Har newPage() {
        return this.newPage(null, null);
    }

    public Har newPage(String pageRef) {
        return this.newPage(pageRef, null);
    }

    public Har newPage(final String pageRef, final String pageTitle) {
        if (!this.mitmProxyManager.isRunning()) {
            return null;
        }
        HarResponse response = this.addonsManagerClient.getRequestToAddonsManager("har", "new_page", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"pageRef", (Object)String.valueOf(pageRef)));
                this.add(Pair.of((Object)"pageTitle", (Object)String.valueOf(pageTitle)));
            }
        }, HarResponse.class);
        return this.parseHar(response.path);
    }

    public void endPage() {
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("har", "end_page", Collections.emptyList(), Void.class);
    }

    private Har parseHar(String filePath) {
        Har har;
        File harFile = new File(filePath);
        try {
            har = (Har)new ObjectMapper().readerFor(Har.class).readValue(harFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read HAR file: " + harFile.getAbsolutePath(), e);
        }
        return har;
    }

    public void setHarCaptureTypes(final EnumSet<CaptureType> captureTypes) {
        this.lastCaptureTypes = captureTypes;
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("har", "set_har_capture_types", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"captureTypes", (Object)String.valueOf(captureTypes)));
            }
        }, Void.class);
    }

    public EnumSet<CaptureType> getLastCaptureTypes() {
        return this.lastCaptureTypes;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class HarResponse {
        private String path;

        public HarResponse() {
        }

        public HarResponse(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }
}

