/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.proxy.dns;

import com.browserup.bup.proxy.dns.AdvancedHostResolver;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public abstract class AbstractHostNameRemapper
implements AdvancedHostResolver {
    private final AtomicReference<ImmutableMap<String, String>> remappedHostNames = new AtomicReference<ImmutableMap>(ImmutableMap.of());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapHosts(Map<String, String> hostRemappings) {
        AtomicReference<ImmutableMap<String, String>> atomicReference = this.remappedHostNames;
        synchronized (atomicReference) {
            ImmutableMap newRemappings = ImmutableMap.copyOf(hostRemappings);
            this.remappedHostNames.set((ImmutableMap<String, String>)newRemappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapHost(String originalHost, String remappedHost) {
        AtomicReference<ImmutableMap<String, String>> atomicReference = this.remappedHostNames;
        synchronized (atomicReference) {
            Map currentHostRemappings = (Map)this.remappedHostNames.get();
            LinkedHashMap builderMap = Maps.newLinkedHashMap((Map)currentHostRemappings);
            builderMap.remove(originalHost);
            builderMap.put(originalHost, remappedHost);
            ImmutableMap newRemappings = ImmutableMap.copyOf((Map)builderMap);
            this.remappedHostNames.set((ImmutableMap<String, String>)newRemappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHostRemapping(String originalHost) {
        AtomicReference<ImmutableMap<String, String>> atomicReference = this.remappedHostNames;
        synchronized (atomicReference) {
            Map currentHostRemappings = (Map)this.remappedHostNames.get();
            if (currentHostRemappings.containsKey(originalHost)) {
                LinkedHashMap builderMap = Maps.newLinkedHashMap((Map)currentHostRemappings);
                builderMap.remove(originalHost);
                ImmutableMap newRemappings = ImmutableMap.copyOf((Map)builderMap);
                this.remappedHostNames.set((ImmutableMap<String, String>)newRemappings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearHostRemappings() {
        AtomicReference<ImmutableMap<String, String>> atomicReference = this.remappedHostNames;
        synchronized (atomicReference) {
            this.remappedHostNames.set((ImmutableMap<String, String>)ImmutableMap.of());
        }
    }

    @Override
    public Map<String, String> getHostRemappings() {
        return (Map)this.remappedHostNames.get();
    }

    @Override
    public Collection<String> getOriginalHostnames(String remappedHost) {
        Map currentRemappings = (Map)this.remappedHostNames.get();
        List<String> originalHostnames = currentRemappings.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(remappedHost)).map(Map.Entry::getKey).collect(Collectors.toList());
        return originalHostnames;
    }

    public String applyRemapping(String originalHost) {
        String remappedHost = (String)this.remappedHostNames.get().get((Object)originalHost);
        if (remappedHost != null) {
            return remappedHost;
        }
        return originalHost;
    }

    public abstract Collection<InetAddress> resolveRemapped(String var1);

    @Override
    public Collection<InetAddress> resolve(String originalHost) {
        String remappedHost = this.applyRemapping(originalHost);
        return this.resolveRemapped(remappedHost);
    }
}

