/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.util;

import com.browserup.bup.exception.DecompressionException;
import com.browserup.bup.util.HttpUtil;
import com.google.common.net.HostAndPort;
import com.google.common.net.MediaType;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.brotli.dec.BrotliInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUpHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(BrowserUpHttpUtil.class);
    public static final String UNKNOWN_CONTENT_TYPE = "application/octet-stream";
    public static final Charset DEFAULT_HTTP_CHARSET = StandardCharsets.UTF_8;
    public static final int DECOMPRESS_BUFFER_SIZE = 16192;

    public static long getHeaderSize(HttpHeaders headers) {
        return headers.entries().stream().mapToLong(header -> ((String)header.getKey()).length() + ((String)header.getValue()).length() + 4).sum();
    }

    public static byte[] decompressGZIPContents(byte[] fullMessage) throws DecompressionException {
        InflaterInputStream gzipReader = null;
        try {
            int bytesRead;
            gzipReader = new GZIPInputStream(new ByteArrayInputStream(fullMessage));
            ByteArrayOutputStream uncompressed = new ByteArrayOutputStream(fullMessage.length);
            byte[] decompressBuffer = new byte[16192];
            while ((bytesRead = gzipReader.read(decompressBuffer)) > -1) {
                uncompressed.write(decompressBuffer, 0, bytesRead);
            }
            fullMessage = uncompressed.toByteArray();
        }
        catch (IOException e) {
            throw new DecompressionException("Unable to decompress response", e);
        }
        finally {
            try {
                if (gzipReader != null) {
                    gzipReader.close();
                }
            }
            catch (IOException e) {
                log.warn("Unable to close gzip stream", (Throwable)e);
            }
        }
        return fullMessage;
    }

    public static byte[] decompressBrotliContents(byte[] fullMessage) throws DecompressionException {
        InputStream brotliReader = null;
        try {
            int bytesRead;
            brotliReader = new BrotliInputStream((InputStream)new ByteArrayInputStream(fullMessage));
            ByteArrayOutputStream uncompressed = new ByteArrayOutputStream(fullMessage.length);
            byte[] decompressBuffer = new byte[16192];
            while ((bytesRead = brotliReader.read(decompressBuffer)) > -1) {
                uncompressed.write(decompressBuffer, 0, bytesRead);
            }
            fullMessage = uncompressed.toByteArray();
        }
        catch (IOException e) {
            throw new DecompressionException("Unable to decompress response", e);
        }
        finally {
            try {
                if (brotliReader != null) {
                    brotliReader.close();
                }
            }
            catch (IOException e) {
                log.warn("Unable to close brotli stream", (Throwable)e);
            }
        }
        return fullMessage;
    }

    public static boolean hasTextualContent(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/x-javascript") || contentType.startsWith("application/javascript") || contentType.startsWith("application/json") || contentType.startsWith("application/xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/") && contentType.endsWith("+json"));
    }

    public static byte[] extractReadableBytes(ByteBuf content) {
        byte[] binaryContent = new byte[content.readableBytes()];
        content.markReaderIndex();
        content.readBytes(binaryContent);
        content.resetReaderIndex();
        return binaryContent;
    }

    public static String getContentAsString(byte[] content, Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Charset cannot be null");
        }
        return new String(content, charset);
    }

    public static Charset readCharsetInContentTypeHeader(String contentTypeHeader) throws com.browserup.bup.exception.UnsupportedCharsetException {
        MediaType mediaType;
        if (contentTypeHeader == null || contentTypeHeader.isEmpty()) {
            return null;
        }
        try {
            mediaType = MediaType.parse((String)contentTypeHeader);
        }
        catch (IllegalArgumentException e) {
            log.info("Unable to parse Content-Type header: {}. Content-Type header will be ignored.", (Object)contentTypeHeader, (Object)e);
            return null;
        }
        try {
            return (Charset)mediaType.charset().orNull();
        }
        catch (UnsupportedCharsetException e) {
            throw new com.browserup.bup.exception.UnsupportedCharsetException(e);
        }
    }

    public static String getRawPathAndParamsFromRequest(HttpRequest httpRequest) throws URISyntaxException {
        if (HttpUtil.startsWithHttpOrHttps((String)httpRequest.uri())) {
            return BrowserUpHttpUtil.getRawPathAndParamsFromUri(httpRequest.uri());
        }
        new URI(httpRequest.uri());
        return httpRequest.uri();
    }

    public static String getRawPathAndParamsFromUri(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        String path = uri.getRawPath();
        String query = uri.getRawQuery();
        if (query != null) {
            return path + '?' + query;
        }
        return path;
    }

    public static boolean isRedirect(HttpResponse httpResponse) {
        switch (httpResponse.status().code()) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public static String removeMatchingPort(String hostWithPort, int portNumber) {
        HostAndPort parsedHostAndPort = HostAndPort.fromString((String)hostWithPort);
        if (parsedHostAndPort.hasPort() && parsedHostAndPort.getPort() == portNumber) {
            return HostAndPort.fromHost((String)parsedHostAndPort.getHost()).toString();
        }
        return hostWithPort;
    }

    public static String base64EncodeBasicCredentials(String username, String password) {
        String credentialsToEncode = username + ':' + password;
        byte[] credentialsAsUtf8Bytes = credentialsToEncode.getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(credentialsAsUtf8Bytes);
    }
}

