/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.harreader.model;

import com.browserup.harreader.filter.HarEntriesFilter;
import com.browserup.harreader.filter.HarEntriesUrlPatternFilter;
import com.browserup.harreader.model.HarCreatorBrowser;
import com.browserup.harreader.model.HarEntry;
import com.browserup.harreader.model.HarPage;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HarLog {
    protected static final String DEFAULT_VERSION = "1.1";
    private String version = "1.1";
    private HarCreatorBrowser creator;
    private HarCreatorBrowser browser;
    private List<HarPage> pages = new CopyOnWriteArrayList<HarPage>();
    private List<HarEntry> entries = new CopyOnWriteArrayList<HarEntry>();
    private String comment;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version == null || version.trim().equals("")) {
            version = DEFAULT_VERSION;
        }
        this.version = version;
    }

    public HarCreatorBrowser getCreator() {
        if (this.creator == null) {
            this.creator = new HarCreatorBrowser();
        }
        return this.creator;
    }

    public void setCreator(HarCreatorBrowser creator) {
        this.creator = creator;
    }

    public HarCreatorBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(HarCreatorBrowser browser) {
        this.browser = browser;
    }

    public List<HarPage> getPages() {
        if (this.pages == null) {
            this.pages = new CopyOnWriteArrayList<HarPage>();
        }
        return this.pages;
    }

    public void setPages(List<HarPage> pages) {
        this.pages = pages;
    }

    public List<HarEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new CopyOnWriteArrayList<HarEntry>();
        }
        return this.entries;
    }

    public void setEntries(List<HarEntry> entries) {
        this.entries = entries;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HarLog harLog = (HarLog)o;
        return Objects.equals(this.version, harLog.version) && Objects.equals(this.creator, harLog.creator) && Objects.equals(this.browser, harLog.browser) && Objects.equals(this.pages, harLog.pages) && Objects.equals(this.entries, harLog.entries) && Objects.equals(this.comment, harLog.comment);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.creator, this.browser, this.pages, this.entries, this.comment);
    }

    public Optional<HarEntry> findMostRecentEntry() {
        return this.getEntries().stream().max(Comparator.comparing(HarEntry::getStartedDateTime));
    }

    public Optional<HarEntry> findMostRecentEntry(Pattern url) {
        return this.findEntries(new HarEntriesUrlPatternFilter(url)).stream().max(Comparator.comparing(HarEntry::getStartedDateTime));
    }

    public List<HarEntry> findEntries(Pattern url) {
        return this.findEntries(new HarEntriesUrlPatternFilter(url));
    }

    private List<HarEntry> findEntries(HarEntriesFilter filter) {
        return this.getEntries().stream().filter(filter).collect(Collectors.toList());
    }
}

