/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.util;

import com.google.common.net.HostAndPort;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;

public class HttpUtil {
    public static String getHostFromRequest(HttpRequest httpRequest) {
        String host = null;
        if (HttpUtil.startsWithHttpOrHttps(httpRequest.uri())) {
            try {
                URI uri = new URI(httpRequest.uri());
                host = uri.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return HttpUtil.parseHost(host, httpRequest, false);
    }

    public static String getHostAndPortFromRequest(HttpRequest httpRequest) {
        String host = null;
        if (HttpUtil.startsWithHttpOrHttps(httpRequest.uri())) {
            try {
                host = HttpUtil.getHostAndPortFromUri(httpRequest.uri());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return HttpUtil.parseHost(host, httpRequest, true);
    }

    public static boolean startsWithHttpOrHttps(String uri) {
        if (uri == null) {
            return false;
        }
        String lowercaseUri = uri.toLowerCase(Locale.US);
        return lowercaseUri.startsWith("http://") || lowercaseUri.startsWith("https://");
    }

    public static String getHostAndPortFromUri(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        if (uri.getPort() == -1) {
            return uri.getHost();
        }
        return HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort()).toString();
    }

    private static String parseHost(String host, HttpRequest httpRequest, boolean includePort) {
        if (HttpUtil.isEmpty(host)) {
            host = HttpUtil.parseHostHeader(httpRequest, includePort);
        }
        if (HttpUtil.isEmpty(host)) {
            host = HttpUtil.hostFromConnect(httpRequest, includePort);
        }
        return host;
    }

    private static String parseHostHeader(HttpRequest httpRequest, boolean includePort) {
        List hosts = httpRequest.headers().getAll((CharSequence)HttpHeaderNames.HOST);
        if (!hosts.isEmpty()) {
            String hostAndPort = (String)hosts.get(0);
            if (includePort) {
                return hostAndPort;
            }
            HostAndPort parsedHostAndPort = HostAndPort.fromString((String)hostAndPort);
            return parsedHostAndPort.getHost();
        }
        return null;
    }

    private static String hostFromConnect(HttpRequest httpRequest, boolean includePort) {
        if (HttpMethod.CONNECT.equals((Object)httpRequest.method())) {
            if (includePort) {
                return httpRequest.uri();
            }
            HostAndPort parsedHostAndPort = HostAndPort.fromString((String)httpRequest.uri());
            return parsedHostAndPort.getHost();
        }
        return null;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

