/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.equinox.datalocation;

import com.github.veithen.cosmos.equinox.datalocation.AbstractLocation;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Location.class}, property={"type=osgi.instance.area"}, xmlns="http://www.osgi.org/xmlns/scr/v1.1.0")
public final class TempInstanceArea
extends AbstractLocation {
    private static final Logger logger = LoggerFactory.getLogger(TempInstanceArea.class);
    private Path defaultDirectory;
    private URL defaultUrl;
    private Thread shutdownHook;

    public TempInstanceArea() {
        super(null, false);
    }

    @Deactivate
    private void deactivate() {
        if (this.defaultDirectory != null) {
            this.delete();
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    @Override
    public synchronized URL getDefault() {
        if (this.defaultUrl == null) {
            try {
                this.defaultDirectory = Files.createTempDirectory("osgi.instance", new FileAttribute[0]);
                this.shutdownHook = new Thread(){

                    @Override
                    public void run() {
                        TempInstanceArea.this.delete();
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                this.defaultUrl = this.defaultDirectory.toUri().toURL();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to create temporary directory for instance data", ex);
            }
        }
        return this.defaultUrl;
    }

    private void delete() {
        try {
            Files.walkFileTree(this.defaultDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            logger.error(String.format("Failed to delete directory %s", this.defaultDirectory), (Throwable)ex);
        }
    }
}

