/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.service.log;

import com.github.veithen.cosmos.osgi.service.log.AbstractLogger;
import com.github.veithen.cosmos.osgi.service.log.FormatterLoggerImpl;
import com.github.veithen.cosmos.osgi.service.log.LogLevel;
import com.github.veithen.cosmos.osgi.service.log.LoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.FormatterLogger;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

final class LogServiceImpl
implements LogService {
    private final Bundle bundle;
    private final LoggerImpl defaultLogger;

    LogServiceImpl(Bundle bundle) {
        this.bundle = bundle;
        this.defaultLogger = new LoggerImpl(bundle, "osgi");
    }

    public Logger getLogger(String name) {
        return this.getLogger(this.bundle, name, Logger.class);
    }

    public Logger getLogger(Class<?> clazz) {
        return this.getLogger(this.bundle, clazz.getName(), Logger.class);
    }

    public <L extends Logger> L getLogger(String name, Class<L> loggerType) {
        return this.getLogger(this.bundle, name, loggerType);
    }

    public <L extends Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
        return this.getLogger(this.bundle, clazz.getName(), loggerType);
    }

    public <L extends Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType) {
        AbstractLogger logger;
        if (loggerType == Logger.class) {
            logger = new LoggerImpl(bundle, name);
        } else if (loggerType == FormatterLogger.class) {
            logger = new FormatterLoggerImpl(bundle, name);
        } else {
            throw new IllegalArgumentException();
        }
        return (L)((Logger)loggerType.cast(logger));
    }

    private LogLevel getLogLevel(int level) {
        switch (level) {
            case 4: {
                return LogLevel.DEBUG;
            }
            case 3: {
                return LogLevel.INFO;
            }
            case 2: {
                return LogLevel.WARN;
            }
            case 1: {
                return LogLevel.ERROR;
            }
        }
        throw new IllegalArgumentException();
    }

    public void log(int level, String message) {
        this.defaultLogger.log(this.getLogLevel(level), message, new Object[0]);
    }

    public void log(int level, String message, Throwable exception) {
        this.defaultLogger.log(this.getLogLevel(level), message, exception);
    }

    public void log(ServiceReference<?> sr, int level, String message) {
        this.defaultLogger.log(this.getLogLevel(level), message, sr);
    }

    public void log(ServiceReference<?> sr, int level, String message, Throwable exception) {
        this.defaultLogger.log(this.getLogLevel(level), message, sr, exception);
    }
}

