/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.hermetic;

import com.github.veithen.maven.hermetic.PathSpec;
import com.github.veithen.maven.hermetic.PathUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.Writer;
import java.security.Permission;
import org.apache.commons.text.StringEscapeUtils;

final class PolicyWriter {
    private final Writer out;

    PolicyWriter(Writer out) {
        this.out = out;
    }

    void start() throws IOException {
        this.out.write("grant {\n");
    }

    void writePermission(String permissionClassName, String targetName, String action) throws IOException {
        this.out.write("  permission ");
        this.out.write(permissionClassName);
        this.out.write(" \"");
        this.out.write(StringEscapeUtils.escapeJava((String)targetName));
        this.out.write(34);
        if (action != null) {
            this.out.write(", \"");
            this.out.write(StringEscapeUtils.escapeJava((String)action));
            this.out.write(34);
        }
        this.out.write(";\n");
    }

    void writePermission(Permission permission) throws IOException {
        String actions = permission.getActions();
        this.writePermission(permission.getClass().getName(), permission.getName(), actions.isEmpty() ? null : actions);
    }

    void generateDirPermissions(File dir, int maxDepth, boolean allowWrite) throws IOException {
        String rootActions = allowWrite ? "read,readlink,write" : "read,readlink";
        String actions = allowWrite ? "read,readlink,write,delete" : "read,readlink";
        for (PathSpec pathSpec : PathUtil.enumeratePaths(dir.getAbsoluteFile().toPath(), maxDepth)) {
            this.writePermission(new FilePermission(pathSpec.path().toString(), pathSpec.depth() == 0 ? rootActions : actions));
            if (!pathSpec.directory()) continue;
            this.writePermission(new FilePermission(pathSpec.path().resolve("-").toString(), actions));
        }
    }

    void end() throws IOException {
        this.out.write("};\n");
    }
}

