/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco;

import com.github.veithen.maven.jacoco.CoverageContext;
import com.github.veithen.maven.jacoco.CoverageService;
import com.github.veithen.maven.jacoco.Source;
import com.github.veithen.maven.jacoco.TravisContext;
import java.util.Iterator;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;

final class Coveralls
implements CoverageService {
    private final WebTarget target;

    Coveralls(WebTarget target) {
        this.target = target;
    }

    @Override
    public String getName() {
        return "Coveralls";
    }

    @Override
    public boolean isEnabled(TravisContext travisContext) {
        if (travisContext == null) {
            return false;
        }
        try {
            this.target.path("github/{user}/{repo}.json").resolveTemplate("user", (Object)travisContext.getUser()).resolveTemplate("repo", (Object)travisContext.getRepository()).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JsonObject.class);
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }

    @Override
    public String upload(TravisContext travisContext, CoverageContext coverageContext) throws MojoFailureException {
        JsonArrayBuilder sourceFilesBuilder = Json.createArrayBuilder();
        for (IPackageCoverage packageCoverage : coverageContext.getBundle().getPackages()) {
            ISourceFileCoverage sourceFileCoverage;
            Source source;
            Iterator iterator = packageCoverage.getSourceFiles().iterator();
            while (iterator.hasNext() && (source = coverageContext.lookupSource(sourceFileCoverage = (ISourceFileCoverage)iterator.next())) != null) {
                int i;
                JsonArrayBuilder coverageBuilder = Json.createArrayBuilder();
                for (i = 1; i < sourceFileCoverage.getFirstLine(); ++i) {
                    coverageBuilder.add(JsonValue.NULL);
                }
                block7: for (i = sourceFileCoverage.getFirstLine(); i <= sourceFileCoverage.getLastLine(); ++i) {
                    switch (sourceFileCoverage.getLine(i).getStatus()) {
                        case 0: {
                            coverageBuilder.add(JsonValue.NULL);
                            continue block7;
                        }
                        case 1: {
                            coverageBuilder.add(0);
                            continue block7;
                        }
                        default: {
                            coverageBuilder.add(1);
                        }
                    }
                }
                sourceFilesBuilder.add((JsonValue)Json.createObjectBuilder().add("name", source.getPathRelativeToRepositoryRoot()).add("source_digest", source.digest()).add("coverage", (JsonValue)coverageBuilder.build()).build());
            }
        }
        JsonObject jsonFile = Json.createObjectBuilder().add("service_name", "travis-ci").add("service_job_id", travisContext.getJobId()).add("source_files", (JsonValue)sourceFilesBuilder.build()).build();
        FormDataMultiPart multipart = new FormDataMultiPart();
        multipart.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"json_file").fileName("coverage.json")).build(), (Object)jsonFile, MediaType.APPLICATION_JSON_TYPE));
        return ((JsonObject)this.target.path("api/v1/jobs").request().post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()), JsonObject.class)).getString("url");
    }
}

