/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco;

import com.github.veithen.maven.jacoco.Codecov;
import com.github.veithen.maven.jacoco.CoverageContext;
import com.github.veithen.maven.jacoco.CoverageData;
import com.github.veithen.maven.jacoco.CoverageService;
import com.github.veithen.maven.jacoco.Coveralls;
import com.github.veithen.maven.jacoco.Ipfs;
import com.github.veithen.maven.jacoco.Lazy;
import com.github.veithen.maven.jacoco.TravisContext;
import com.github.veithen.maven.jacoco.UserAgentFeature;
import com.github.veithen.maven.shared.mojo.aggregating.AggregatingMojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;

@Mojo(name="process", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, threadSafe=true)
public final class ProcessMojo
extends AggregatingMojo<CoverageData> {
    @Parameter(defaultValue="${project.build.directory}/jacoco.exec", required=true)
    private File dataFile;
    @Parameter(defaultValue="${env.TRAVIS_REPO_SLUG}", readonly=true)
    private String repoSlug;
    @Parameter(defaultValue="${env.TRAVIS_JOB_ID}", readonly=true)
    private String jobId;
    @Parameter(defaultValue="${env.TRAVIS_JOB_NUMBER}", readonly=true)
    private String jobNumber;
    @Parameter(defaultValue="${env.TRAVIS_JOB_WEB_URL}", readonly=true)
    private String jobUrl;
    @Parameter(defaultValue="${env.TRAVIS_BRANCH}", readonly=true)
    private String branch;
    @Parameter(defaultValue="${env.TRAVIS_COMMIT}", readonly=true)
    private String commit;
    @Parameter(defaultValue="true")
    private boolean includeClasses;
    @Parameter(defaultValue="https://coveralls.io", required=true)
    private String coverallsApiEndpoint;
    @Parameter(defaultValue="https://codecov.io", required=true)
    private String codecovApiEndpoint;
    @Parameter(defaultValue="http://localhost:5001", required=true)
    private String ipfsApiEndpoint;

    public ProcessMojo() {
        super(CoverageData.class);
    }

    private static boolean isChild(File parent, File child) {
        for (File candidate = child; candidate != null; candidate = candidate.getParentFile()) {
            if (!candidate.equals(parent)) continue;
            return true;
        }
        return false;
    }

    protected CoverageData doExecute() throws MojoExecutionException, MojoFailureException {
        boolean dataFileExists = this.dataFile.exists();
        HashMap<String, File> sources = new HashMap<String, File>();
        if (this.includeClasses) {
            File buildDirectory = new File(this.project.getBuild().getDirectory());
            for (String compileSourceRoot : this.project.getCompileSourceRoots()) {
                File basedir = new File(compileSourceRoot);
                if (ProcessMojo.isChild(buildDirectory, basedir) || !basedir.exists()) continue;
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(basedir);
                scanner.scan();
                for (String includedFile : scanner.getIncludedFiles()) {
                    sources.put(includedFile, new File(basedir, includedFile));
                }
            }
        }
        if (dataFileExists || !sources.isEmpty()) {
            File classes = new File(this.project.getBuild().getOutputDirectory());
            return new CoverageData(dataFileExists ? this.dataFile : null, this.includeClasses && classes.exists() ? classes : null, sources);
        }
        return null;
    }

    private File findRootDir() {
        File rootDir = this.project.getBasedir();
        while (!new File(rootDir, ".git").exists()) {
            if ((rootDir = rootDir.getParentFile()) != null) continue;
            throw new IllegalStateException("Root directory not found; are we running from a Git clone?");
        }
        return rootDir;
    }

    private static <T> Iterable<T> toIterable(Stream<T> stream) {
        return stream::iterator;
    }

    static MojoFailureException processException(String serviceName, WebApplicationException exception) {
        String message = null;
        try {
            JsonObject entity = (JsonObject)exception.getResponse().readEntity(JsonObject.class);
            if (entity.getBoolean("error", true)) {
                message = entity.getString("message", null);
            }
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
        if (message == null) {
            message = exception.getMessage();
        }
        return new MojoFailureException(String.format("Failed to send request to %s: %s", serviceName, message), (Throwable)exception);
    }

    protected void doAggregate(List<CoverageData> results) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (results.stream().map(CoverageData::getDataFile).allMatch(Objects::isNull)) {
            log.info((CharSequence)"No coverage data collected; skipping execution.");
            return;
        }
        if (results.stream().map(CoverageData::getClasses).allMatch(Objects::isNull)) {
            log.info((CharSequence)"No classes included; skipping execution.");
            return;
        }
        TravisContext travisContext = this.repoSlug != null && this.jobId != null && this.jobNumber != null && this.jobUrl != null && this.branch != null && this.commit != null ? new TravisContext(this.repoSlug, this.jobId, this.jobNumber, this.jobUrl, this.branch, this.commit) : null;
        Client client = ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register(MultiPartFeature.class)).register(UserAgentFeature.class)).build();
        ArrayList<CoverageService> coverageServices = new ArrayList<CoverageService>();
        coverageServices.add(new Coveralls(client.target(this.coverallsApiEndpoint)));
        coverageServices.add(new Codecov(client.target(this.codecovApiEndpoint)));
        coverageServices.add(new Ipfs(client.target(this.ipfsApiEndpoint)));
        Iterator it = coverageServices.iterator();
        while (it.hasNext()) {
            CoverageService service = (CoverageService)it.next();
            if (service.isEnabled(travisContext)) continue;
            log.info((CharSequence)String.format("%s not configured/enabled", service.getName()));
            it.remove();
        }
        if (coverageServices.isEmpty()) {
            log.info((CharSequence)"No usable coverage services found; skipping execution.");
            return;
        }
        ExecFileLoader loader = new ExecFileLoader();
        for (File dataFile : ProcessMojo.toIterable(results.stream().map(CoverageData::getDataFile).filter(Objects::nonNull))) {
            try {
                loader.load(dataFile);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(String.format("Failed to load exec file %s: %s", dataFile, ex.getMessage()), (Exception)ex);
            }
        }
        CoverageBuilder builder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), (ICoverageVisitor)builder);
        for (File classes : ProcessMojo.toIterable(results.stream().map(CoverageData::getClasses).filter(Objects::nonNull))) {
            try {
                analyzer.analyzeAll(classes);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(String.format("Failed to analyze %s: %s", classes, ex.getMessage()), (Exception)ex);
            }
        }
        HashMap<String, File> sourceFiles = new HashMap<String, File>();
        results.stream().map(CoverageData::getSources).forEach(sourceFiles::putAll);
        IBundleCoverage bundle = builder.getBundle("Coverage Report");
        CoverageContext coverageContext = new CoverageContext(loader, bundle, sourceFiles, new Lazy<File>(this::findRootDir));
        for (CoverageService service : coverageServices) {
            String link;
            try {
                link = service.upload(travisContext, coverageContext);
            }
            catch (WebApplicationException ex) {
                throw ProcessMojo.processException(service.getName(), ex);
            }
            log.info((CharSequence)String.format("Successfully uploaded coverage data to %s: %s", service.getName(), link));
        }
    }
}

