/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.shared.mojo.aggregating;

import com.github.veithen.maven.shared.mojo.aggregating.AggregationHelper;
import com.github.veithen.maven.shared.mojo.aggregating.AggregationHelperFactory;
import com.github.veithen.rbeans.RBeanFactoryException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AggregatingMojo<T extends Serializable>
extends AbstractMojo {
    private final Class<T> resultType;
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="session", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(property="mojoExecution", readonly=true, required=true)
    protected MojoExecution mojoExecution;

    public AggregatingMojo(Class<T> resultType) {
        this.resultType = resultType;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        List<Serializable> results;
        AggregationHelper aggregationHelper;
        try {
            aggregationHelper = AggregationHelperFactory.getAggregationHelper();
        }
        catch (RBeanFactoryException | IOException ex) {
            throw new MojoFailureException(ex.getMessage(), ex);
        }
        T result = this.doExecute();
        try {
            results = aggregationHelper.addResult(this.project, this.mavenSession, this.mojoExecution, (Serializable)result, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new MojoFailureException("Failed to serialize/deserialize Mojo results", (Throwable)ex);
        }
        if (results != null) {
            this.doAggregate(results.stream().map(this.resultType::cast).collect(Collectors.toList()));
        }
    }

    protected abstract T doExecute() throws MojoExecutionException, MojoFailureException;

    protected abstract void doAggregate(List<T> var1) throws MojoExecutionException, MojoFailureException;
}

