/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.shared.mojo.aggregating.helper;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;

final class AggregationKey {
    private final String pluginId;
    private final String goal;

    private AggregationKey(String pluginId, String goal) {
        this.pluginId = pluginId;
        this.goal = goal;
    }

    static AggregationKey from(MojoExecution mojoExecution) {
        return new AggregationKey(mojoExecution.getPlugin().getId(), mojoExecution.getGoal());
    }

    static Set<AggregationKey> from(Plugin plugin, PluginExecution pluginExecution) {
        String pluginId = plugin.getId();
        return pluginExecution.getGoals().stream().map(goal -> new AggregationKey(pluginId, (String)goal)).collect(Collectors.toSet());
    }

    public int hashCode() {
        return this.pluginId.hashCode() + 31 * this.goal.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AggregationKey) {
            AggregationKey other = (AggregationKey)obj;
            return other.pluginId.equals(this.pluginId) && other.goal.equals(this.goal);
        }
        return false;
    }
}

