/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.shared.mojo.aggregating.helper;

import com.github.veithen.maven.shared.mojo.aggregating.helper.AggregationKey;
import com.github.veithen.maven.shared.mojo.aggregating.helper.ConfigurableObjectInputStream;
import com.github.veithen.maven.shared.mojo.aggregating.helper.ExecutionKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;

final class Aggregator {
    private final Set<ExecutionKey> executionKeys = new HashSet<ExecutionKey>();
    private final List<byte[]> serializedResults;

    Aggregator(MavenSession mavenSession, AggregationKey aggregationKey) {
        for (MavenProject project : mavenSession.getProjects()) {
            for (Plugin plugin : project.getBuildPlugins()) {
                for (PluginExecution execution : plugin.getExecutions()) {
                    if (!AggregationKey.from(plugin, execution).contains(aggregationKey)) continue;
                    this.executionKeys.add(ExecutionKey.from(project, execution));
                }
            }
        }
        this.serializedResults = new ArrayList<byte[]>(this.executionKeys.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Serializable> addResult(ExecutionKey executionKey, Serializable result, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        boolean isLast;
        Object oos;
        if (result != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            ((ObjectOutputStream)oos).writeObject(result);
            ((ObjectOutputStream)oos).close();
            this.serializedResults.add(baos.toByteArray());
        }
        oos = this.executionKeys;
        synchronized (oos) {
            this.executionKeys.remove(executionKey);
            isLast = this.executionKeys.isEmpty();
        }
        if (isLast) {
            ArrayList<Serializable> results = new ArrayList<Serializable>(this.serializedResults.size());
            for (byte[] serializedResult : this.serializedResults) {
                results.add((Serializable)new ConfigurableObjectInputStream(new ByteArrayInputStream(serializedResult), classLoader).readObject());
            }
            return results;
        }
        return null;
    }
}

