/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.shared.mojo.aggregating.helper;

import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

final class ExecutionKey {
    private final String projectId;
    private final String executionId;

    private ExecutionKey(String projectId, String executionId) {
        this.projectId = projectId;
        this.executionId = executionId;
    }

    static ExecutionKey from(MavenProject project, MojoExecution mojoExecution) {
        return new ExecutionKey(project.getId(), mojoExecution.getExecutionId());
    }

    static ExecutionKey from(MavenProject project, PluginExecution pluginExecution) {
        return new ExecutionKey(project.getId(), pluginExecution.getId());
    }

    public int hashCode() {
        return this.projectId.hashCode() + 31 * this.executionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionKey) {
            ExecutionKey other = (ExecutionKey)obj;
            return other.projectId.equals(this.projectId) && other.executionId.equals(this.executionId);
        }
        return false;
    }

    public String toString() {
        return this.projectId + ":" + this.executionId;
    }
}

