/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.github.victools.jsonschema.generator.ConfigFunction;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.StatefulConfig;
import com.github.victools.jsonschema.generator.TypeScope;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SchemaGeneratorTypeConfigPart<S extends TypeScope>
implements StatefulConfig {
    private final List<ConfigFunction<S, String>> titleResolvers = new ArrayList<ConfigFunction<S, String>>();
    private final List<ConfigFunction<S, String>> descriptionResolvers = new ArrayList<ConfigFunction<S, String>>();
    private final List<ConfigFunction<S, Object>> defaultResolvers = new ArrayList<ConfigFunction<S, Object>>();
    private final List<ConfigFunction<S, Collection<?>>> enumResolvers = new ArrayList();
    private final List<BiFunction<S, SchemaGenerationContext, JsonNode>> additionalPropertiesResolvers = new ArrayList<BiFunction<S, SchemaGenerationContext, JsonNode>>();
    private final List<BiFunction<S, SchemaGenerationContext, Map<String, JsonNode>>> patternPropertiesResolvers = new ArrayList<BiFunction<S, SchemaGenerationContext, Map<String, JsonNode>>>();
    private final List<ConfigFunction<S, Integer>> stringMinLengthResolvers = new ArrayList<ConfigFunction<S, Integer>>();
    private final List<ConfigFunction<S, Integer>> stringMaxLengthResolvers = new ArrayList<ConfigFunction<S, Integer>>();
    private final List<ConfigFunction<S, String>> stringFormatResolvers = new ArrayList<ConfigFunction<S, String>>();
    private final List<ConfigFunction<S, String>> stringPatternResolvers = new ArrayList<ConfigFunction<S, String>>();
    private final List<ConfigFunction<S, BigDecimal>> numberInclusiveMinimumResolvers = new ArrayList<ConfigFunction<S, BigDecimal>>();
    private final List<ConfigFunction<S, BigDecimal>> numberExclusiveMinimumResolvers = new ArrayList<ConfigFunction<S, BigDecimal>>();
    private final List<ConfigFunction<S, BigDecimal>> numberInclusiveMaximumResolvers = new ArrayList<ConfigFunction<S, BigDecimal>>();
    private final List<ConfigFunction<S, BigDecimal>> numberExclusiveMaximumResolvers = new ArrayList<ConfigFunction<S, BigDecimal>>();
    private final List<ConfigFunction<S, BigDecimal>> numberMultipleOfResolvers = new ArrayList<ConfigFunction<S, BigDecimal>>();
    private final List<ConfigFunction<S, Integer>> arrayMinItemsResolvers = new ArrayList<ConfigFunction<S, Integer>>();
    private final List<ConfigFunction<S, Integer>> arrayMaxItemsResolvers = new ArrayList<ConfigFunction<S, Integer>>();
    private final List<ConfigFunction<S, Boolean>> arrayUniqueItemsResolvers = new ArrayList<ConfigFunction<S, Boolean>>();

    protected static <S extends TypeScope, R> R getFirstDefinedValue(List<ConfigFunction<S, R>> resolvers, S scope) {
        return resolvers.stream().map(resolver -> resolver.apply(scope)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected static <S extends TypeScope, R> R getFirstDefinedValue(List<BiFunction<S, SchemaGenerationContext, R>> resolvers, S scope, SchemaGenerationContext context) {
        return resolvers.stream().map(resolver -> resolver.apply(scope, context)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public SchemaGeneratorTypeConfigPart<S> withTitleResolver(ConfigFunction<S, String> resolver) {
        this.titleResolvers.add(resolver);
        return this;
    }

    public String resolveTitle(S scope) {
        return (String)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.titleResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withDescriptionResolver(ConfigFunction<S, String> resolver) {
        this.descriptionResolvers.add(resolver);
        return this;
    }

    public String resolveDescription(S scope) {
        return (String)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.descriptionResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withDefaultResolver(ConfigFunction<S, Object> resolver) {
        this.defaultResolvers.add(resolver);
        return this;
    }

    public Object resolveDefault(S scope) {
        return SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.defaultResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withEnumResolver(ConfigFunction<S, Collection<?>> resolver) {
        this.enumResolvers.add(resolver);
        return this;
    }

    public Collection<?> resolveEnum(S scope) {
        return (Collection)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.enumResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withAdditionalPropertiesResolver(ConfigFunction<S, Type> resolver) {
        return this.withAdditionalPropertiesResolver((S scope, SchemaGenerationContext context) -> {
            Type additionalPropertiesType = (Type)resolver.apply(scope);
            if (additionalPropertiesType == null) {
                return null;
            }
            if (additionalPropertiesType == Void.class || additionalPropertiesType == Void.TYPE) {
                return BooleanNode.FALSE;
            }
            ResolvedType resolvedAdditionalPropertiesType = context.getTypeContext().resolve(additionalPropertiesType, new Type[0]);
            if (resolvedAdditionalPropertiesType.getErasedType() == Object.class) {
                return BooleanNode.TRUE;
            }
            return context.createDefinitionReference(resolvedAdditionalPropertiesType);
        });
    }

    public SchemaGeneratorTypeConfigPart<S> withAdditionalPropertiesResolver(BiFunction<S, SchemaGenerationContext, JsonNode> resolver) {
        this.additionalPropertiesResolvers.add(resolver);
        return this;
    }

    public JsonNode resolveAdditionalProperties(S scope, SchemaGenerationContext context) {
        return (JsonNode)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.additionalPropertiesResolvers, scope, context);
    }

    public SchemaGeneratorTypeConfigPart<S> withPatternPropertiesResolver(ConfigFunction<S, Map<String, Type>> resolver) {
        return this.withPatternPropertiesResolver((S scope, SchemaGenerationContext context) -> {
            Map patternTypes = (Map)resolver.apply(scope);
            if (patternTypes == null) {
                return null;
            }
            return patternTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> context.createDefinitionReference(context.getTypeContext().resolve((Type)entry.getValue(), new Type[0]))));
        });
    }

    public SchemaGeneratorTypeConfigPart<S> withPatternPropertiesResolver(BiFunction<S, SchemaGenerationContext, Map<String, JsonNode>> resolver) {
        this.patternPropertiesResolvers.add(resolver);
        return this;
    }

    public Map<String, JsonNode> resolvePatternProperties(S scope, SchemaGenerationContext context) {
        return (Map)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.patternPropertiesResolvers, scope, context);
    }

    public SchemaGeneratorTypeConfigPart<S> withStringMinLengthResolver(ConfigFunction<S, Integer> resolver) {
        this.stringMinLengthResolvers.add(resolver);
        return this;
    }

    public Integer resolveStringMinLength(S scope) {
        return (Integer)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.stringMinLengthResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withStringMaxLengthResolver(ConfigFunction<S, Integer> resolver) {
        this.stringMaxLengthResolvers.add(resolver);
        return this;
    }

    public Integer resolveStringMaxLength(S scope) {
        return (Integer)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.stringMaxLengthResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withStringFormatResolver(ConfigFunction<S, String> resolver) {
        this.stringFormatResolvers.add(resolver);
        return this;
    }

    public String resolveStringFormat(S scope) {
        return (String)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.stringFormatResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withStringPatternResolver(ConfigFunction<S, String> resolver) {
        this.stringPatternResolvers.add(resolver);
        return this;
    }

    public String resolveStringPattern(S scope) {
        return (String)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.stringPatternResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withNumberInclusiveMinimumResolver(ConfigFunction<S, BigDecimal> resolver) {
        this.numberInclusiveMinimumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberInclusiveMinimum(S scope) {
        return (BigDecimal)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.numberInclusiveMinimumResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withNumberExclusiveMinimumResolver(ConfigFunction<S, BigDecimal> resolver) {
        this.numberExclusiveMinimumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberExclusiveMinimum(S scope) {
        return (BigDecimal)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.numberExclusiveMinimumResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withNumberInclusiveMaximumResolver(ConfigFunction<S, BigDecimal> resolver) {
        this.numberInclusiveMaximumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberInclusiveMaximum(S scope) {
        return (BigDecimal)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.numberInclusiveMaximumResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withNumberExclusiveMaximumResolver(ConfigFunction<S, BigDecimal> resolver) {
        this.numberExclusiveMaximumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberExclusiveMaximum(S scope) {
        return (BigDecimal)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.numberExclusiveMaximumResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withNumberMultipleOfResolver(ConfigFunction<S, BigDecimal> resolver) {
        this.numberMultipleOfResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberMultipleOf(S scope) {
        return (BigDecimal)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.numberMultipleOfResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withArrayMinItemsResolver(ConfigFunction<S, Integer> resolver) {
        this.arrayMinItemsResolvers.add(resolver);
        return this;
    }

    public Integer resolveArrayMinItems(S scope) {
        return (Integer)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.arrayMinItemsResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withArrayMaxItemsResolver(ConfigFunction<S, Integer> resolver) {
        this.arrayMaxItemsResolvers.add(resolver);
        return this;
    }

    public Integer resolveArrayMaxItems(S scope) {
        return (Integer)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.arrayMaxItemsResolvers, scope);
    }

    public SchemaGeneratorTypeConfigPart<S> withArrayUniqueItemsResolver(ConfigFunction<S, Boolean> resolver) {
        this.arrayUniqueItemsResolvers.add(resolver);
        return this;
    }

    public Boolean resolveArrayUniqueItems(S scope) {
        return (Boolean)SchemaGeneratorTypeConfigPart.getFirstDefinedValue(this.arrayUniqueItemsResolvers, scope);
    }

    @Override
    public void resetAfterSchemaGenerationFinished() {
        Stream.of(this.titleResolvers, this.descriptionResolvers, this.defaultResolvers, this.enumResolvers, this.stringMinLengthResolvers, this.stringMaxLengthResolvers, this.stringFormatResolvers, this.stringPatternResolvers, this.numberInclusiveMinimumResolvers, this.numberExclusiveMinimumResolvers, this.numberInclusiveMaximumResolvers, this.numberExclusiveMaximumResolvers, this.numberMultipleOfResolvers, this.arrayMinItemsResolvers, this.arrayMaxItemsResolvers, this.arrayUniqueItemsResolvers).flatMap(Collection::stream).forEach(StatefulConfig::resetAfterSchemaGenerationFinished);
    }
}

