/*
 * Decompiled with CFR 0.152.
 */
package com.github.vsspt.xjc;

import com.github.vsspt.xjc.model.ClassRepresentation;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class AbstractVssPluginImpl
extends Plugin {
    protected static final String SEPARATOR = ",";

    protected abstract String getAnnotationName();

    protected abstract boolean checkAnnotationsFields();

    protected abstract void generateMethod(ClassRepresentation var1, List<JFieldVar> var2, boolean var3);

    public boolean run(Outline outline, Options options, ErrorHandler arg2) throws SAXException {
        HashMap<String, ClassRepresentation> classes = new HashMap<String, ClassRepresentation>();
        for (ClassOutline classOutline : outline.getClasses()) {
            ClassRepresentation classRepresentation = new ClassRepresentation(classOutline, this.getAnnotationName(), this.checkAnnotationsFields());
            if (!classRepresentation.isValidForAugument()) continue;
            classes.put(classRepresentation.getName(), classRepresentation);
        }
        this.generateCode(outline, classes);
        return true;
    }

    protected void generateCode(Outline outline, Map<String, ClassRepresentation> classes) {
        for (ClassOutline classOutline : outline.getClasses()) {
            String key = classOutline.implClass.name();
            ClassRepresentation clazz = classes.get(key);
            if (clazz == null) continue;
            JDefinedClass implementationClass = classOutline.implClass;
            HashMap<String, List<JFieldVar>> fields = new HashMap<String, List<JFieldVar>>();
            for (JFieldVar field : implementationClass.fields().values()) {
                if (!clazz.getFieldsFromAnnotations().contains(field.name())) continue;
                ArrayList<JFieldVar> classFields = (ArrayList<JFieldVar>)fields.get(key);
                if (classFields == null) {
                    classFields = new ArrayList<JFieldVar>();
                }
                classFields.add(field);
                fields.put(key, classFields);
            }
            this.generateMethod(clazz, (List)fields.get(implementationClass.name()), this.checkForSuperClassFields((ClassOutlineImpl)classOutline, fields));
        }
    }

    protected boolean checkForSuperClassFields(ClassOutlineImpl classOutline, Map<String, List<JFieldVar>> classFields) {
        if (classOutline.getSuperClass() == null) {
            return false;
        }
        String key = classOutline.getSuperClass().implClass.name();
        List<JFieldVar> fields = classFields.get(key);
        return fields == null || fields.isEmpty();
    }
}

