/*
 * Decompiled with CFR 0.152.
 */
package com.github.vsspt.xjc.setter;

import com.github.vsspt.xjc.AbstractVssPluginImpl;
import com.github.vsspt.xjc.annotation.Setter;
import com.github.vsspt.xjc.model.ClassRepresentation;
import com.google.common.collect.ImmutableList;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.generator.bean.field.UntypedListField;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PluginImpl
extends AbstractVssPluginImpl {
    private static final String OPTION_NAME = "XvsSetter";
    private static final String USAGE = "XvsSetter :  create setter accessors";
    private static final String OPERATION_PREFIX = "set";
    private static final String PARAM_NAME = "value";
    private static final String COPY_OF = "copyOf";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return USAGE;
    }

    @Override
    protected String getAnnotationName() {
        return Setter.class.getName();
    }

    @Override
    protected boolean checkAnnotationsFields() {
        return true;
    }

    @Override
    protected void generateMethod(ClassRepresentation clazz, List<JFieldVar> includeFields, boolean hasSuperClassFields) {
        JDefinedClass implClass = clazz.getClassOutline().implClass;
        List<String> listFieldNames = this.getListFieldNames(clazz.getClassOutline().getDeclaredFields());
        ArrayList clonedList = new ArrayList();
        Collection fields = implClass.fields().values();
        if (fields != null && !fields.isEmpty()) {
            clonedList.addAll(implClass.fields().values());
            for (JFieldVar field : clonedList) {
                if (includeFields == null || !includeFields.contains(field) || !listFieldNames.contains(field.name())) continue;
                JMethod method = implClass.method(1, Void.TYPE, OPERATION_PREFIX + this.capitalizeFirstLetter(field.name()));
                JVar var = method.param(8, field.type(), PARAM_NAME);
                JBlock block = new JBlock();
                JClass immutableListClass = implClass.owner().ref(ImmutableList.class);
                JInvocation invocation = block.staticInvoke(immutableListClass, COPY_OF);
                invocation.arg((JExpression)var);
                method.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)invocation);
            }
        }
    }

    private List<String> getListFieldNames(FieldOutline[] fields) {
        ArrayList<String> values = new ArrayList<String>();
        if (fields == null) {
            return values;
        }
        for (FieldOutline fo : fields) {
            if (!(fo instanceof UntypedListField)) continue;
            values.add(fo.getPropertyInfo().getName(false));
        }
        return values;
    }

    private String capitalizeFirstLetter(String value) {
        return value == null ? null : value.substring(0, 1).toUpperCase() + value.substring(1);
    }
}

