/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import java.nio.charset.StandardCharsets;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.Dictionary;

public class StringAttribute
extends RadiusAttribute {
    StringAttribute(Dictionary dictionary, int vendorId, int type, byte[] data) {
        super(dictionary, vendorId, type, data);
        if (data.length < 1) {
            throw new IllegalArgumentException("String attribute value should be min 1 octet, actual: " + data.length);
        }
    }

    StringAttribute(Dictionary dictionary, int vendorId, int type, String value) {
        this(dictionary, vendorId, type, value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getValueString() {
        return new String(this.getValue(), StandardCharsets.UTF_8);
    }
}

