/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.tinyradius.attribute.AttributeType;
import org.tinyradius.attribute.Attributes;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.Dictionary;

public class VendorSpecificAttribute
extends RadiusAttribute {
    public static final int VENDOR_SPECIFIC = 26;
    private final List<RadiusAttribute> subAttributes;

    VendorSpecificAttribute(Dictionary dictionary, int ignoredVendorId, int ignoredAttributeType, byte[] data) {
        this(dictionary, VendorSpecificAttribute.extractVendorId(data), Attributes.extractAttributes(dictionary, VendorSpecificAttribute.extractVendorId(data), data, 4));
    }

    private static int extractVendorId(byte[] data) {
        return ByteBuffer.wrap(data).getInt();
    }

    VendorSpecificAttribute(Dictionary dictionary, int vendorId, int ignored, String ignored2) {
        this(dictionary, vendorId, new ArrayList<RadiusAttribute>());
    }

    VendorSpecificAttribute(Dictionary dictionary, int vendorId, List<RadiusAttribute> subAttributes) {
        super(dictionary, vendorId, 26, new byte[0]);
        this.subAttributes = subAttributes;
    }

    public VendorSpecificAttribute(Dictionary dictionary, int vendorId) {
        this(dictionary, vendorId, new ArrayList<RadiusAttribute>());
    }

    public void addSubAttribute(RadiusAttribute attribute) {
        if (attribute.getVendorId() != this.getVendorId()) {
            throw new IllegalArgumentException("sub attribute has incorrect vendor ID");
        }
        this.subAttributes.add(attribute);
    }

    public void addSubAttribute(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("type name is empty");
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("value is empty");
        }
        AttributeType type = this.lookupAttributeType(name);
        RadiusAttribute attribute = Attributes.createAttribute(this.getDictionary(), this.getVendorId(), type.getTypeCode(), value);
        this.addSubAttribute(attribute);
    }

    public void removeSubAttribute(RadiusAttribute attribute) {
        this.subAttributes.remove(attribute);
    }

    public List<RadiusAttribute> getSubAttributes() {
        return this.subAttributes;
    }

    public List<RadiusAttribute> getSubAttributes(int attributeType) {
        return this.subAttributes.stream().filter(sa -> sa.getType() == attributeType).collect(Collectors.toList());
    }

    public RadiusAttribute getSubAttribute(int type) {
        List<RadiusAttribute> attrs = this.getSubAttributes(type);
        if (attrs.size() > 1) {
            throw new RuntimeException("multiple sub-attributes of requested type " + type);
        }
        return attrs.isEmpty() ? null : attrs.get(0);
    }

    public RadiusAttribute getSubAttribute(String type) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("type name is empty");
        }
        return this.getSubAttribute(this.lookupAttributeType(type).getTypeCode());
    }

    private AttributeType lookupAttributeType(String name) {
        AttributeType type = this.getDictionary().getAttributeTypeByName(name);
        if (type == null) {
            throw new IllegalArgumentException("unknown attribute type name'" + name + "'");
        }
        if (type.getVendorId() == -1) {
            throw new IllegalArgumentException("attribute type '" + name + "' is not a Vendor-Specific sub-attribute");
        }
        if (type.getVendorId() != this.getVendorId()) {
            throw new IllegalArgumentException("attribute type '" + name + "' does not belong to vendor ID " + this.getVendorId());
        }
        return type;
    }

    @Override
    public byte[] toByteArray() {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeByte(26);
        buffer.writeByte(0);
        buffer.writeInt(this.getVendorId());
        for (RadiusAttribute attribute : this.subAttributes) {
            buffer.writeBytes(attribute.toByteArray());
        }
        byte[] array = buffer.copy().array();
        int len = array.length;
        if (len < 7) {
            throw new RuntimeException("Vendor-Specific attribute should be greater than 6 octets, actual: " + len);
        }
        if (len > 255) {
            throw new RuntimeException("Vendor-Specific attribute should be less than 256 octets, actual: " + len);
        }
        array[1] = (byte)len;
        return array;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Vendor-Specific: ");
        String vendorName = this.getDictionary().getVendorName(this.getVendorId());
        if (vendorName != null) {
            sb.append(vendorName).append(" (").append(this.getVendorId()).append(")");
        } else {
            sb.append("vendor ID ").append(this.getVendorId());
        }
        for (RadiusAttribute sa : this.getSubAttributes()) {
            sb.append("\n  ").append(sa.toString());
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> toAttributeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.subAttributes.forEach(a -> map.putAll(a.toAttributeMap()));
        return map;
    }
}

