/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinyradius.client.PendingRequestCtx;
import org.tinyradius.client.timeout.TimeoutHandler;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusEndpoint;

public class RadiusClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(RadiusClient.class);
    private final TimeoutHandler timeoutHandler;
    private final EventLoopGroup eventLoopGroup;
    private final ChannelFuture channelFuture;

    public RadiusClient(Bootstrap bootstrap, SocketAddress listenAddress, TimeoutHandler timeoutHandler, ChannelHandler handler) {
        this.eventLoopGroup = bootstrap.config().group();
        this.timeoutHandler = timeoutHandler;
        this.channelFuture = ((Bootstrap)bootstrap.clone().handler(handler)).bind(listenAddress);
    }

    public Future<RadiusPacket> communicate(RadiusPacket packet, RadiusEndpoint endpoint) {
        Promise promise = this.eventLoopGroup.next().newPromise().addListener(f -> {
            if (f.isSuccess()) {
                logger.info("Response received, packet: {}", f.getNow());
            } else {
                logger.warn(f.cause().getMessage());
            }
        });
        this.channelFuture.addListener(s -> {
            if (s.isSuccess()) {
                this.send(new PendingRequestCtx(packet, endpoint, (Promise<RadiusPacket>)promise), 1);
            } else {
                promise.tryFailure(s.cause());
            }
        });
        return promise;
    }

    private void send(PendingRequestCtx ctx, int attempt) {
        logger.info("Attempt {}, sending packet to {}", (Object)attempt, (Object)ctx.getEndpoint().getAddress());
        this.channelFuture.channel().writeAndFlush((Object)ctx);
        this.timeoutHandler.onTimeout(() -> this.send(ctx, attempt + 1), attempt, ctx.getResponse());
    }

    @Override
    public void close() {
        this.channelFuture.channel().close();
    }
}

