/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.client.timeout;

import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.tinyradius.client.timeout.TimeoutHandler;
import org.tinyradius.packet.RadiusPacket;

public class BasicTimeoutHandler
implements TimeoutHandler {
    private final Timer timer;
    private final int maxAttempts;
    private final int timeoutMs;

    public BasicTimeoutHandler(Timer timer) {
        this(timer, 1, 1000);
    }

    public BasicTimeoutHandler(Timer timer, int maxAttempts, int timeoutMs) {
        this.timer = timer;
        this.maxAttempts = maxAttempts;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public void onTimeout(Runnable callback, int totalAttempts, Promise<RadiusPacket> promise) {
        this.timer.newTimeout(t -> {
            if (promise.isDone()) {
                return;
            }
            if (totalAttempts >= this.maxAttempts) {
                promise.tryFailure((Throwable)new IOException("Client send failed, max attempts reached: " + this.maxAttempts));
            } else {
                callback.run();
            }
        }, (long)this.timeoutMs, TimeUnit.MILLISECONDS);
    }
}

