/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.dictionary;

import java.util.HashMap;
import java.util.Map;
import org.tinyradius.attribute.AttributeType;
import org.tinyradius.dictionary.WritableDictionary;

public class MemoryDictionary
implements WritableDictionary {
    private final Map<Integer, String> vendorsByCode = new HashMap<Integer, String>();
    private final Map<Integer, Map<Integer, AttributeType>> attributesByCode = new HashMap<Integer, Map<Integer, AttributeType>>();
    private final Map<String, AttributeType> attributesByName = new HashMap<String, AttributeType>();

    @Override
    public AttributeType getAttributeTypeByCode(int typeCode) {
        return this.getAttributeTypeByCode(-1, typeCode);
    }

    @Override
    public AttributeType getAttributeTypeByCode(int vendorCode, int typeCode) {
        Map<Integer, AttributeType> vendorAttributes = this.attributesByCode.get(vendorCode);
        return vendorAttributes == null ? null : vendorAttributes.get(typeCode);
    }

    @Override
    public AttributeType getAttributeTypeByName(String typeName) {
        return this.attributesByName.get(typeName);
    }

    @Override
    public int getVendorId(String vendorName) {
        for (Map.Entry<Integer, String> v : this.vendorsByCode.entrySet()) {
            if (!v.getValue().equals(vendorName)) continue;
            return v.getKey();
        }
        return -1;
    }

    @Override
    public String getVendorName(int vendorId) {
        return this.vendorsByCode.get(vendorId);
    }

    @Override
    public void addVendor(int vendorId, String vendorName) {
        if (vendorId < 0) {
            throw new IllegalArgumentException("vendor ID must be positive");
        }
        if (this.getVendorName(vendorId) != null) {
            throw new IllegalArgumentException("duplicate vendor code");
        }
        if (vendorName == null || vendorName.isEmpty()) {
            throw new IllegalArgumentException("vendor name empty");
        }
        this.vendorsByCode.put(vendorId, vendorName);
    }

    @Override
    public void addAttributeType(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException("attribute type must not be null");
        }
        int vendorId = attributeType.getVendorId();
        int typeCode = attributeType.getTypeCode();
        String attributeName = attributeType.getName();
        if (this.attributesByName.containsKey(attributeName)) {
            throw new IllegalArgumentException("duplicate attribute name: " + attributeName);
        }
        Map vendorAttributes = this.attributesByCode.computeIfAbsent(vendorId, k -> new HashMap());
        if (vendorAttributes.containsKey(typeCode)) {
            throw new IllegalArgumentException("duplicate type code: " + typeCode);
        }
        this.attributesByName.put(attributeName, attributeType);
        vendorAttributes.put(typeCode, attributeType);
    }
}

