/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tinyradius.attribute.Attributes;
import org.tinyradius.attribute.IntegerAttribute;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.dictionary.Dictionary;
import org.tinyradius.packet.RadiusPacket;

public class AccountingRequest
extends RadiusPacket {
    private static final int USER_NAME = 1;
    private static final int ACCT_STATUS_TYPE = 40;
    public static final int ACCT_STATUS_TYPE_START = 1;
    public static final int ACCT_STATUS_TYPE_STOP = 2;
    public static final int ACCT_STATUS_TYPE_INTERIM_UPDATE = 3;
    public static final int ACCT_STATUS_TYPE_ACCOUNTING_ON = 7;
    public static final int ACCT_STATUS_TYPE_ACCOUNTING_OFF = 8;

    public AccountingRequest(Dictionary dictionary, int identifier, byte[] authenticator, String userName, int acctStatusType) {
        this(dictionary, identifier, authenticator);
        this.setUserName(userName);
        this.setAcctStatusType(acctStatusType);
    }

    public AccountingRequest(Dictionary dictionary, int identifier, byte[] authenticator) {
        this(dictionary, identifier, authenticator, new ArrayList<RadiusAttribute>());
    }

    public AccountingRequest(Dictionary dictionary, int identifier, byte[] authenticator, List<RadiusAttribute> attributes) {
        super(dictionary, 4, identifier, authenticator, attributes);
    }

    public void setUserName(String userName) {
        Objects.requireNonNull(userName, "user name not set");
        if (userName.isEmpty()) {
            throw new IllegalArgumentException("empty user name not allowed");
        }
        this.removeAttributes(1);
        this.addAttribute(Attributes.createAttribute(this.getDictionary(), -1, 1, userName));
    }

    public String getUserName() {
        RadiusAttribute attribute = this.getAttribute(1);
        return attribute == null ? null : attribute.getValueString();
    }

    public void setAcctStatusType(int acctStatusType) {
        if (acctStatusType < 1 || acctStatusType > 15) {
            throw new IllegalArgumentException("bad Acct-Status-Type");
        }
        this.removeAttributes(40);
        this.addAttribute(new IntegerAttribute(this.getDictionary(), -1, 40, acctStatusType));
    }

    public int getAcctStatusType() {
        RadiusAttribute ra = this.getAttribute(40);
        return ra == null ? -1 : ((IntegerAttribute)ra).getValueInt();
    }
}

