/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.server;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadiusServer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(RadiusServer.class);
    private final ChannelFuture accessFuture;
    private final ChannelFuture accountingFuture;
    private final Promise<Void> isReady;

    public RadiusServer(Bootstrap bootstrap, ChannelHandler accessHandler, ChannelHandler accountingHandler, InetSocketAddress accessSocket, InetSocketAddress accountingSocket) {
        this.accessFuture = ((Bootstrap)bootstrap.clone().handler(accessHandler)).bind((SocketAddress)accessSocket);
        this.accountingFuture = ((Bootstrap)bootstrap.clone().handler(accountingHandler)).bind((SocketAddress)accountingSocket);
        this.isReady = bootstrap.config().group().next().newPromise();
        PromiseCombiner combiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        combiner.addAll(new Future[]{this.accessFuture, this.accountingFuture});
        combiner.finish(this.isReady);
        this.isReady.addListener(f -> {
            if (f.isSuccess()) {
                logger.info("Server started on {} and {}", (Object)this.accessFuture.channel().localAddress(), (Object)this.accountingFuture.channel().localAddress());
            } else {
                logger.info("Could not start server on {} and {}", (Object)this.accessFuture.channel().localAddress(), (Object)this.accountingFuture.channel().localAddress());
            }
        });
    }

    public Future<Void> isReady() {
        return this.isReady;
    }

    public Channel getAuthChannel() {
        return this.accessFuture.channel();
    }

    public Channel getAcctChannel() {
        return this.accountingFuture.channel();
    }

    @Override
    public void close() {
        logger.info("Closing server on {} and {}", (Object)this.accessFuture.channel().localAddress(), (Object)this.accountingFuture.channel().localAddress());
        this.accessFuture.channel().close();
        this.accountingFuture.channel().close();
    }
}

