/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.server.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.Timer;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinyradius.server.RequestCtx;
import org.tinyradius.server.ResponseCtx;

public class BasicCachingHandler<IN extends RequestCtx, OUT extends ResponseCtx>
extends MessageToMessageCodec<IN, OUT> {
    private static final Logger logger = LoggerFactory.getLogger(BasicCachingHandler.class);
    private final Timer timer;
    private final int ttlMs;
    private final Map<Packet, OUT> requests = new ConcurrentHashMap<Packet, OUT>();

    public BasicCachingHandler(Timer timer, int ttlMs, Class<IN> inboundClass, Class<OUT> outboundClass) {
        super(inboundClass, outboundClass);
        this.timer = timer;
        this.ttlMs = ttlMs;
    }

    protected void onMiss(ChannelHandlerContext ctx, IN requestContext) {
    }

    protected void onHit(ChannelHandlerContext ctx, OUT responseContext) {
    }

    protected void decode(ChannelHandlerContext ctx, IN msg, List<Object> out) {
        Packet packet = Packet.from(msg);
        ResponseCtx responseContext = (ResponseCtx)this.requests.get(packet);
        if (responseContext != null) {
            logger.debug("Cache hit, resending response, id: {}, remote address: {}", (Object)packet.identifier, (Object)packet.remoteAddress);
            this.onHit(ctx, responseContext);
            ctx.writeAndFlush((Object)responseContext);
        } else {
            logger.debug("Cache miss, proxying request, id: {}, remote address: {}", (Object)packet.identifier, (Object)packet.remoteAddress);
            this.onMiss(ctx, msg);
            out.add(msg);
        }
    }

    protected void encode(ChannelHandlerContext ctx, OUT msg, List<Object> out) {
        Packet packet = Packet.from(msg);
        this.requests.put(packet, msg);
        this.timer.newTimeout(t -> this.requests.remove(packet), (long)this.ttlMs, TimeUnit.MILLISECONDS);
        out.add(msg);
    }

    private static class Packet {
        private final int identifier;
        private final InetSocketAddress remoteAddress;
        private final byte[] authenticator;

        private static Packet from(RequestCtx ctx) {
            return new Packet(ctx.getRequest().getIdentifier(), ctx.getEndpoint().getAddress(), ctx.getRequest().getAuthenticator());
        }

        private Packet(int identifier, InetSocketAddress remoteAddress, byte[] authenticator) {
            this.identifier = identifier;
            this.remoteAddress = remoteAddress;
            this.authenticator = authenticator;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Packet packet = (Packet)o;
            return this.identifier == packet.identifier && Objects.equals(this.remoteAddress, packet.remoteAddress) && Arrays.equals(this.authenticator, packet.authenticator);
        }

        public int hashCode() {
            int result = Objects.hash(this.identifier, this.remoteAddress);
            result = 31 * result + Arrays.hashCode(this.authenticator);
            return result;
        }
    }
}

