/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.server.handler;

import io.netty.channel.SimpleChannelInboundHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.server.RequestCtx;

public abstract class RequestHandler
extends SimpleChannelInboundHandler<RequestCtx> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected abstract Class<? extends RadiusPacket> acceptedPacketType();

    public boolean acceptInboundMessage(Object msg) throws Exception {
        boolean acceptInboundMessage = super.acceptInboundMessage(msg);
        if (!acceptInboundMessage) {
            return false;
        }
        RadiusPacket request = ((RequestCtx)msg).getRequest();
        if (this.acceptedPacketType().isInstance(request)) {
            return true;
        }
        this.logger.debug("{} does not accept <{}>", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)request.getClass().getSimpleName());
        return false;
    }
}

