/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.util;

import java.net.InetSocketAddress;
import java.util.Objects;

public class RadiusEndpoint {
    private final InetSocketAddress address;
    private final String secret;

    public RadiusEndpoint(InetSocketAddress remoteAddress, String secret) {
        this.address = Objects.requireNonNull(remoteAddress);
        this.secret = Objects.requireNonNull(secret);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RadiusEndpoint endpoint = (RadiusEndpoint)o;
        return this.address.equals(endpoint.address) && this.secret.equals(endpoint.secret);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.secret);
    }
}

