/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.nsqj.spring;

import com.github.yingzhuo.nsqj.DirectSubscriber;
import com.github.yingzhuo.nsqj.Message;
import com.github.yingzhuo.nsqj.MessageHandler;
import com.github.yingzhuo.nsqj.Subscriber;
import com.github.yingzhuo.nsqj.spring.NsqSubscriber;
import com.github.yingzhuo.nsqj.spring.SubscriberConfigurer;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SubscriberRegistry
implements BeanPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SubscriberRegistry.class);
    private SubscriberConfigurer subscriberConfigurer;

    public Object postProcessAfterInitialization(Object object, String string) throws BeansException {
        for (Method method : object.getClass().getMethods()) {
            NsqSubscriber nsqSubscriber = method.getAnnotation(NsqSubscriber.class);
            if (nsqSubscriber == null) continue;
            this.register(nsqSubscriber, method, object);
        }
        return object;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            this.subscriberConfigurer = (SubscriberConfigurer)applicationContext.getBean(SubscriberConfigurer.class);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
    }

    private void register(NsqSubscriber nsqSubscriber, final Method method, final Object object) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1 || classArray[0] != Message.class) {
            return;
        }
        int n = nsqSubscriber.lookupIntervalSecs();
        String string = nsqSubscriber.topic();
        String string2 = nsqSubscriber.channel();
        String[] stringArray = nsqSubscriber.nsqdHosts();
        String[] stringArray2 = nsqSubscriber.lookupHosts();
        int n2 = nsqSubscriber.maxLookupFailuresBeforeError();
        if (stringArray2.length == 0) {
            log.debug("register DirectSubscriber topic={} channel={}", (Object)string, (Object)string2);
            DirectSubscriber directSubscriber = new DirectSubscriber(n, stringArray);
            directSubscriber.setDefaultMaxInFlight(nsqSubscriber.defaultMaxInFlight());
            if (this.subscriberConfigurer != null) {
                this.subscriberConfigurer.config((Subscriber)directSubscriber, string, string2);
            }
            directSubscriber.subscribe(string, string2, new MessageHandler(){

                public void accept(Message message) {
                    try {
                        method.invoke(object, message);
                    }
                    catch (Exception exception) {
                        log.error(exception.getMessage(), (Throwable)exception);
                    }
                }
            });
            return;
        }
        log.debug("register Subscriber topic={} channel={}", (Object)string, (Object)string2);
        Subscriber subscriber = new Subscriber(n, n2, stringArray2);
        subscriber.setDefaultMaxInFlight(nsqSubscriber.defaultMaxInFlight());
        if (this.subscriberConfigurer != null) {
            this.subscriberConfigurer.config(subscriber, string, string2);
        }
        subscriber.subscribe(string, string2, new MessageHandler(){

            public void accept(Message message) {
                try {
                    method.invoke(object, message);
                }
                catch (Exception exception) {
                    log.error(exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }
}

