/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuchi.semver;

import java.util.Arrays;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class REWrapper {
    private boolean _global = false;
    private Pattern _pattern = null;
    private String _raw = null;

    protected REWrapper(String raw) {
        this(raw, false);
    }

    protected REWrapper(String raw, boolean global) {
        this._raw = raw;
        this._global = global;
    }

    public Matcher match(CharSequence input) {
        return this.getPattern().matcher(input);
    }

    public boolean matches(CharSequence input) {
        return Pattern.matches(this._raw, input);
    }

    public String replace(String input, String replacement) {
        if (this._global) {
            return input.replaceAll(this._raw, replacement);
        }
        return input.replaceFirst(this._raw, replacement);
    }

    public String replace(String input, Function<Matcher, StringBuilder> fn) {
        Matcher m = this.getPattern().matcher(input);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (m.find()) {
            sb.append(input.substring(start, m.start()));
            sb.append((CharSequence)fn.apply(m));
            start = m.end();
        }
        sb.append(input.substring(start));
        return sb.toString();
    }

    public Stream<String> replaceWithTokensStream(String input, Function<Matcher, StringBuilder> fn) {
        Matcher m = this.getPattern().matcher(input);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while (m.find()) {
            sb.append(input.substring(start, m.start()));
            sb.append((CharSequence)fn.apply(m));
            start = m.end();
        }
        sb.append(input.substring(start));
        return Arrays.stream(sb.toString().split(" "));
    }

    public Pattern getPattern() {
        if (this._pattern == null) {
            this._pattern = Pattern.compile(this._raw);
        }
        return this._pattern;
    }

    public String toString() {
        return this._raw;
    }
}

